# silen v0.1
import pygame, sys, os, re, math
from pygame.locals import *
if __name__ == '__main__':
    pygame.init()
    pygame.display.set_caption('WindowTest!!!!')
    pygame.mouse.set_visible(0)
    screen = pygame.display.set_mode((640,480))
def load_image(name,colorkey=None): #colorkey={None - convert alpha, (R,G,B[,A]) - set colorkey, 0 - do neither)
    fullname = os.path.join('data', name)
    try: image = pygame.image.load(fullname)#name)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    if colorkey == None: image = image.convert_alpha()
    else:
        image = image.convert()
        if colorkey != 0: image.set_colorkey(colorkey)
    return image#, image.get_rect()
class silenCoreVar: #a non-updated optimization for animated values, with faster calcs and quick creation. use as a dict class (class[frame])
    def __init__(self,ftime,dist,animtype): #animtype is 0 [+1 for smooth start][+2 for smooth end][+3 for trigonometric smoothness]
        #self.animtype = animtype
        #self.start = start
        self.dist = dist
        #self.end = start + dist
        self.ftime = ftime
        if animtype == 0: #linear
            self.famt = self.dist/float(ftime)
            self.lambda1 = lambda frame: frame*self.famt
            self.callret = lambda dummy: self.lambda1
        elif animtype == 1: #smooth start
            self.famt = self.dist/float(ftime**2)
            self.lambda1 = lambda frame: (frame**2)*self.famt
            self.callret = lambda dummy: self.lambda1
        elif animtype == 2: #smooth end
            self.famt = -self.dist/float(ftime**2)
            self.lambda1 = lambda frame: self.famt*((frame-self.ftime)**2)+self.dist
            self.callret = lambda dummy: self.lambda1
        elif animtype == 3: #smooth start & end
            self.famt = 2*self.dist/float(ftime**2)
            self.lambda1 = lambda frame: (frame**2)*self.famt
            self.lambda2 = lambda frame: -self.famt*((frame-self.ftime)**2)+self.dist
            self.callret = lambda frame: (frame <= self.ftime/2) and self.lambda1 or self.lambda2
        elif animtype == 4: #trig-based smooth start
            self.famt = self.dist
            self.ftime = math.pi/float(2*ftime)
            self.lambda1 = lambda frame: self.famt*(1-math.cos(frame*self.ftime))
            self.callret = lambda dummy: self.lambda1
        elif animtype == 5: #trig-based smooth end
            self.famt = self.dist
            self.ftime = math.pi/float(2*ftime)
            self.lambda1 = lambda frame: self.famt*math.sin(frame*self.ftime)
            self.callret = lambda dummy: self.lambda1
        elif animtype == 6: #trig-based smooth start & end
            self.famt = self.dist/2.0
            self.ftime = math.pi/float(ftime)
            self.lambda1 = lambda frame: self.famt*(1-math.cos(frame*self.ftime))
            self.callret = lambda dummy: self.lambda1
    def __call__(self,frame=0): return self.callret(frame)(frame)
    def __getitem__(self,frame=0): return self.callret(frame)(frame)
    """
        if self.animtype == 0: return frame*self.famt
        elif self.animtype == 1: return (frame**2)*self.famt
        elif self.animtype == 2: return self.famt*((frame-self.ftime)**2)+self.dist
        elif self.animtype == 3:
            if frame <= self.ftime//2: return self.famt*(frame**2)
            return -self.famt*((frame-self.ftime)**2)+self.dist
    """
class silenLinCtr:
    def __init__(self,maxix,bounce=False,repeat=True,minix=0,startix=0,startdir=1):
        self.max = maxix
        self.min = minix
        self.pos = startix
        self.bounce = bounce
        self.repeat = repeat
        self.active = True
        self.dir = startdir
        self.oneloop = bounce and (maxix-minix)*2 or (maxix-minix)
    def update(self,timestep): #call once per frame, pass amt of time (in frames) that has passed
        if self.active:
            self.pos += timestep*self.dir
            if self.pos >= self.max:
                self.pos = self.max
                if self.bounce: self.dir = -1
                elif self.repeat: self.pos = 0
                else: self.active = False
            if self.pos <= self.min:
                self.pos = self.min
                if self.repeat: self.dir = 1
                else: self.active = False
    def __call__(self): return self.pos
class silenAnimVar: #handles a core var and linear counter together. updated each frame. called directly to get value.
    def __init__(self,ftime,dist,animtype,bounce=False,repeat=True,delay=0.0,tie=None,minix=0,startix=0,startdir=1):
        self.data = silenCoreVar(ftime,dist,animtype)
        self.cframe = silenLinCtr(ftime,bounce,repeat,minix,startix,startdir)
        self.offset = dist
        self.delay = delay #pauses animation until zero. decreased by timestep each frame
        self.tie = tie #a tied silenAnimVar, silenVar, or silenSprite. if not None, this var must wait to update until the tie finishes
        #the higher the level of variable, the more dangerous it is to tie. never tie a sprite's action to itself, or face the infinite loop!
    def update(self,timestep):
        if self.tie != None: #until the tied var is finished, this var waits
            if self.tie.active(): return
            self.tie = None
        if self.delay != 0: #until the start delay is done, wait
            self.delay -= timestep
            if self.delay < 0: self.delay = 0
            return
        self.cframe.update(timestep)
    def __call__(self): return self.data[self.cframe()]
    def active(self): return self.cframe.active
class silenVar: #wrapper for silenAnimVar classes. handles all animvars of a particular var, and updates offset when they finish.
    def __init__(self,start=0):
        self.offset = start
        self.data = []
    def add(self,ftime,dist,animtype=0,bounce=False,repeat=False,delay=0.0,tie=None,minix=0,startix=0,startdir=1):
        if not ftime: return None
        coreadd = silenAnimVar(ftime,dist,animtype,bounce,repeat,float(delay),tie,minix,startix,startdir)
        self.data.append(coreadd)
        return coreadd #returns the silenAnimVar created, to make it available to tie to others.
    def __call__(self): return sum([layer() for layer in self.data],self.offset)
    def update(self,timestep=1):
        for layer in self.data:
            layer.update(timestep)
            if not layer.active() and not layer.cframe.bounce: self.offset += layer.offset
        self.data = [layer for layer in self.data if layer.active()]
    def active(self): return (len(self.data) != 0) and True or False
    def cutshort(self,animvar=None): #sets the offset to the closest int reached currently, and clears the specified animvars
        if animvar != None: #update the offset from the one animvar to kill
            try: self.offset += int(self.data.pop( self.data.index(animvar) )()) #add closest int amount reached, and delete entry
            except ValueError: pass #if it can't find the animvar, just ignore
        else: #update the offset from all animvars, then kill them
            for var in self.data: self.offset += int(var())
            self.data = []
    def finishnow(self,animvar=None): # sets the offset to the final offset, and clears the specified animvars
        if animvar != None: #update the offset from the one animvar to kill
            try: self.offset += self.data.pop( self.data.index(animvar) ).offset #add final offset for var, and delete entry
            except ValueError: pass #if it can't find the animvar, just ignore
        else: #update the offset from all animvars, then kill them
            for var in self.data: self.offset += var.offset
            self.data = []
    def final(self): #gets the offset of the var once all other animations are finished (provided they are not cutshort())
        finalval = self.offset
        for var in self.data: finalval += var.offset
        return finalval
class silenPicDelay: #manages an animated sprite in a larger image
    def __init__(self,times,irect,numwide=1,numhigh=1,wrap=True,startix=0,endix=None,starttimer=0,minix=0,maxix=None):
        self.ix = startix #position in the list of times (usually leave default)
        self.timer = starttimer #count on the current ix in the list (usually leave default)
        self.list = times #tuple or list of times for delays
        self.width = irect.width//numwide
        self.height = irect.height//numhigh
        self.numwide = numwide
        self.wrap = wrap #if list repeats
        self.active = True
        self.minix = minix
        if maxix == None: self.maxix = len(times)
        else: self.maxix = maxix
        self.endix = endix
    def update(self,timestep): #call once per frame, pass amt of time (in frames) that has passed
        if self.active:
            self.timer += timestep
            if self.timer >= self.list[self.ix]:
                self.timer = 0
                self.ix += 1
                if self.ix >= self.maxix:
                    if self.wrap: self.ix = self.minix
                    else: self.active = False
                if self.ix == self.endix: self.active = False #this way, None works, and a complete cycle can occur if startix == endix
    def __call__(self): #get the rect for the image to display (within the larger image)
        return Rect(self.width*(self.ix%self.numwide),self.height*(self.ix//self.numwide),self.width,self.height)
class silenSprite:
    timestep = 1.0
    def __init__(self,filename,colorkey=None,cxstart=0,cystart=0,alphastart=255,whtuple=None):
        if filename == None: #for solids, pass None for filename, (R,G,B[,A]) for colorkey, and whtuple for (width,height)
            self.alldata = pygame.Surface(whtuple == None and (640,480) or whtuple).convert_alpha()
            (self.rfill,self.gfill,self.bfill,self.afill) = (silenVar(colorkey[0]),silenVar(colorkey[1]),silenVar(colorkey[2]),silenVar(len(colorkey) >= 4 and colorkey[3] or 0))
        else:
            self.alldata = load_image(filename,colorkey)
            (self.rfill,self.gfill,self.bfill,self.afill) = (silenVar(0),silenVar(0),silenVar(0),silenVar(0))
        self.allrect = self.alldata.get_rect()
        self.cx = silenVar(cxstart)
        self.cy = silenVar(cystart)
        self.xscale = silenVar(1.0) #these vars are proportions only, unfortunately
        self.yscale = silenVar(1.0)
        self.rot = silenVar(0.0)
        self.alpha = silenVar(alphastart) #only works with colorkey pictures
        self.fill = lambda: (self.rfill(),self.gfill(),self.bfill(),self.afill()) #afill only works on surfaces w/ alpha
        self.svlist = [self.cx,self.cy,self.xscale,self.yscale,self.rot,self.alpha,self.rfill,self.gfill,self.bfill,self.afill]
        self.oldxscale = 1.0
        self.oldyscale = 1.0
        self.oldrot = 0.0
        self.oldalpha = 255
        (self.oldrfill,self.oldgfill,self.oldbfill,self.oldafill) = self.oldfill = (0,0,0,0) #same ref, meaning changing one will affect the other (as it should)
        self.data = None
        self.rect = None
        self.pdelay = None
        self.oldpdelay = None
        self.changepic(True)
    def active(self): #if the sprite needs to be updated, this will return true.
        for var in self.svlist:
            if var.active(): return True
        return False
    def makeanim(self,times,numwide=1,numhigh=1,wrap=True,startix=0,endix=None,starttimer=0,minix=0,maxix=None):
        self.pdelay = silenPicDelay(times,self.allrect,numwide,numhigh,wrap,startix,endix,starttimer,minix,maxix)
        self.changepic(True)
    def changepic(self,recalc=False): #after running, self.data will contain the surface to blit, and self.rect will contain its position respective to self.cx and self.cy
        (rot,rotflag) = (self.rot(),False)
        (xs,ys,scaleflag) = (self.xscale(),self.yscale(),False)
        (alpha,alphaflag) = (self.alpha(),False)
        (fill,fillflag) = (self.fill(),False)
        if self.pdelay != None and self.oldpdelay != self.pdelay(): (self.oldpdelay,recalc) = (self.pdelay(),True)
        if rot != self.oldrot: (self.oldrot,rotflag) = (rot,True)
        if xs != self.oldxscale or ys != self.oldyscale: (self.oldxscale,self.oldyscale,scaleflag) = (xs,ys,True)
        if alpha != self.oldalpha: (self.oldalpha,alphaflag) = (alpha,True)
        if fill != self.oldfill:
            (self.oldfill,fillflag) = (fill,True)
            (self.oldrfill,self.oldgfill,self.oldbfill,self.oldafill) = self.oldfill
        if fillflag:
            if self.pdelay != None: (self.oldpdelay,self.data) = (self.pdelay(),(self.alldata.subsurface(self.pdelay())).copy())
            else: (self.oldpdelay,self.data) = (None,self.alldata.copy())
            self.data.fill(fill)
            if rotflag or scaleflag: #these flags could still have significance in a fill surface
                if xs < 0 or ys < 0: self.data = pygame.transform.flip(self.data,(xs<0),(ys<0))
                if abs(xs) != 1.0 or abs(ys)!= 1.0:
                    temprect = self.data.get_rect()
                    self.data = pygame.transform.scale(self.data,(int(abs(xs)*temprect.width),int(abs(ys)*temprect.height))) #scales by width,height
                if rot%360 != 0: self.data = pygame.transform.rotate(self.data,rot)
        elif rotflag or scaleflag or alphaflag or recalc: #surface update is necessary
            if self.pdelay != None: (self.oldpdelay,self.data) = (self.pdelay(),(self.alldata.subsurface(self.pdelay())).copy())
            else: (self.oldpdelay,self.data) = (None,self.alldata.copy())
            if xs < 0 or ys < 0: self.data = pygame.transform.flip(self.data,(xs<0),(ys<0))
            if abs(xs) != 1.0 or abs(ys)!= 1.0:
                temprect = self.data.get_rect()
                self.data = pygame.transform.scale(self.data,(int(abs(xs)*temprect.width),int(abs(ys)*temprect.height))) #scales by width,height
            if rot%360 != 0: self.data = pygame.transform.rotate(self.data,rot)
            if alpha != 255: self.data.set_alpha(alpha)
        temprect = self.data.get_rect()
        self.rect = Rect(self.cx() - temprect.w/2, self.cy() - temprect.h/2, temprect.w, temprect.h)
    def changetimestep(self,timestep=1.0): self.__class__.timestep = timestep
    def update(self):
        for var in self.svlist: var.update(self.__class__.timestep)
        if self.pdelay != None: self.pdelay.update(self.__class__.timestep)
        (rot,alpha) = (self.rot(),self.alpha())
        if rot < 0: self.rot.offset += 360
        if rot >= 360: self.rot.offset -= 360
        if alpha < 0:
            self.alpha.cutshort()
            self.alpha.offset = 0
        if alpha > 255:
            self.alpha.cutshort()
            self.alpha.offset = 255
        self.changepic()
    def __call__(self): return self.data #should always contain the graphic to draw
    def area_rect(self): return self.pdelay != None and self.pdelay() or None #normally not used, this is the area rect in self.alldata, NOT self.data
    def finishfill(self): # finishes fill vars, and clears their anim lists
        self.rfill.finishnow()
        self.gfill.finishnow()
        self.bfill.finishnow()
        self.afill.finishnow()
    def finish(self): #finishes all vars, and clears their anim lists
        for var in self.svlist: var.finishnow()
    def setposa(self,cx,cy): (self.cx.offset,self.cy.offset) = (cx,cy) #set the center position of the sprite absolutely
    def setpos(self,cx,cy): #set the center position of the sprite, relative to the current position
        self.cx.offset += cx
        self.cy.offset += cy
    def movepos(self,cxamt,cyamt,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        avcx = self.cx.add(time,cxamt,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        avcy = self.cy.add(time,cyamt,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        return (avcx,avcy)
    def moveposa(self,cxpos,cypos,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        (cxamt,cyamt) = (cxpos - self.cx.final(),cypos - self.cy.final())
        avcx = self.cx.add(time,cxamt,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        avcy = self.cy.add(time,cyamt,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        return avcx #(avcx,avcy)
    def rotate(self,cwdegs,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        return self.rot.add(time,cwdegs,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
    def fadein(self,time,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        #(amt,self.alpha.data) = (255-self.alpha.offset,[])
        return self.alpha.add(time,255,0,bounce,repeat,delay,tie,minix,startix,startdir)
    def fadeout(self,time,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        #(amt,self.alpha.data) = (-self.alpha.offset,[])
        return self.alpha.add(time,-255,0,bounce,repeat,delay,tie,minix,startix,startdir)
    def scale(self,xprop,yprop,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        avxp = self.xscale.add(time,xprop,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        avyp = self.yscale.add(time,yprop,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        return (avxp,avyp)
    def tweenfill(self,fill,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        if len(fill) < 4: return False
        if fill[0] != None: rtn=self.rfill.add(time,fill[0]-self.rfill.final(),animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        if fill[1] != None: rtn=self.gfill.add(time,fill[1]-self.gfill.final(),animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        if fill[2] != None: rtn=self.bfill.add(time,fill[2]-self.bfill.final(),animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        if fill[3] != None: rtn=self.afill.add(time,fill[3]-self.afill.final(),animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        return rtn
class silenWindowText: #handles one string in a silenWindow-friendly manner (eg. callable, active)
    def __init__(self,window,text):
        self.window = window; self.text = text; self.len = len(text); self.ix = -1; self.active = True; self.go = False
    def __call__(self):
        self.ix += 1
        if self.ix >= self.len: self.active = False; return ''
        return self.text[self.ix]
class silenWindowOpt: #handles one constructed window option externally, called to make change (runs optfcn(args))
    def __init__(self,optfcn,args,keepgoing=False):
        self.optfcn = optfcn; self.args = args; self.text = ''; self.active = False; self.go = keepgoing
    def __call__(self): self.optfcn(self.args); return ''
class silenWindow:
    delay = 0
    fontfile = 'data\default.ttf'
    textre = re.compile(r'((?:/(?:(?:(?:c|s|w)\[.+?\])|(?:\||\.|\^|,|/|:)))|(?::(?:c|s|,)))',re.I)
    def __init__(self,cx,cy,size,bkgcolor,bordercolor,text=None,textcolor=(255,255,255),optionlist=None,borderwidth=1,appear=30,ix=0,voffset=None):
        borderwidth = borderwidth*2 - 1
        if voffset==None: voffset = int(1.2*size)
        self.voffset = voffset
        try: (self.lineht,self.width,self.height) = size; calcwh = False
        except TypeError: self.lineht = size; calcwh = True
        self.font = pygame.font.Font(self.__class__.fontfile,self.lineht)
        self.bkg = bkgcolor; self.border = bordercolor; self.borderwidth = borderwidth
        self.textcolor = textcolor; self.delay = self.__class__.delay
        self.wait = 0; self.cstack = []; self.sstack = []; self.lbl = True
        self.data = self.processtext(text) #this is the linear text in constructable form
        if calcwh:
            temptext = (''.join([ob.text for ob in self.data])).splitlines() #this is the full unformatted text in line-by-line form (needed for width & height)
            numlines = len(temptext)
            self.height = size + voffset*(numlines-1) + 8 + borderwidth
            self.width = max([self.font.size(line)[0] for line in temptext]) + 8 + borderwidth
        #---options will go here--- (so they can use existing text colors/delays)
        self.textcolor = textcolor; self.delay = self.__class__.delay
        self.window = silenSprite(None,bkgcolor,cx,cy,255,(self.width,self.height))
        self.textsurf = None
        self.winanimt = appear
        self.whoffset = self.borderwidth%2 - 2
        if appear:
            self.window.afill.offset = 0; self.window.xscale.offset = 0.0; self.window.yscale.offset = 0.0
            self.window.scale(1.0,1.0,appear,3)
            self.window.tweenfill((None,None,None,(len(bkgcolor)<4 and 255 or bkgcolor[3])),appear,3)
            self.rect = Rect(cx,cy,0,0)
        else:
            self.rect = self.window.rect
            w = self.rect.w + self.whoffset; h = self.rect.h + self.whoffset
            pygame.draw.lines(self.window.data,self.border,True,[(0,0),(0,h),(w,h),(w,0)],self.borderwidth)
        self.closeflag = False; self.active = True #flag for close (True: active = False when animation done), running flag
        self.ix = ix; self.opix = False #cur pos in [] of display obs, current choice
        self.ycur = borderwidth/2 + 1; self.xstart = self.xcur = borderwidth/2 + 7
    def update(self,event): #called once per frame. returns False if an option isn't selected, or option ix if one is selected.
        if self.window.active(): #redraw animated background/border of window
            self.window.update()
            self.rect = self.window.rect
            w = self.rect.w + self.whoffset; h = self.rect.h + self.whoffset
            pygame.draw.lines(self.window.data,self.border,True,[(0,0),(0,h),(w,h),(w,0)],self.borderwidth)
        elif self.closeflag == True: self.active = False #animated window-closing sequence has finished (if there was one)
        elif self.ix < len(self.data): #construct standard text
            if self.wait > 0: self.wait -= 1
            else:
                while True:
                    #print "ix:", self.ix, self.data[self.ix],
                    curob = self.data[self.ix]
                    curchr = None; curchr = curob()
                    #print curchr
                    if curchr == '\n': self.xcur = self.xstart; self.ycur += self.voffset
                    elif curchr != None:
                        chrsurf = self.font.render(curchr,True,self.textcolor)
                        self.window.data.blit(chrsurf,(self.xcur,self.ycur))
                        self.xcur += chrsurf.get_width()
                    if not curob.active: self.ix += 1
                    if not curob.go and self.lbl and curchr != '\n': self.wait += self.delay; return False
    def close(self,dummy=True):
        self.closeflag = True
        if self.winanimt:
            self.window.scale(-1.0,-1.0,self.winanimt,3)
            self.window.tweenfill((None,None,None,0),self.winanimt,3)
        #animate fadeout/scale down of window, fadeout options (or just don't display anymore)
    def processtext(self,text): #process a raw text string (with all special flags, etc.), and return the constructable form. modifies self.[textcolor,delay,cstack,sstack]
        if text == None: return [] #safeguard against no text
        pprtxt = self.__class__.textre.split(text) #text must be a raw string - pprtxt ALWAYS has specials in odd ixs, and strings in even ixs
        #print pprtxt
        data = []
        for i in range(len(pprtxt)):
            if i%2: #odd ix, special formating value
                temp = pprtxt[i]
                if temp[0] == '/': #/ commands
                    if temp[1] == '/' or temp[1] == ':': data[-1].text += temp[1] #escape characters
                    elif temp[1] == 'c': #for :c commands/future \c commands, maintain stack
                        self.cstack.append(self.textcolor); self.textcolor = (int(temp[4:6],16),int(temp[6:8],16),int(temp[8:10],16))
                        data.append(silenWindowOpt(self.settextcolor,self.textcolor,True))
                    elif temp[1] == 's': #for :s commands/future \s commands, maintain stack
                        self.sstack.append(self.delay); self.delay = int(temp[3:-1])
                        data.append(silenWindowOpt(self.setdelay,self.delay,True))
                    elif temp[1] == 'w': data.append(silenWindowOpt(self.addwait,int(temp[3:-1])))
                    elif temp[1] == ',': data.append(silenWindowOpt(self.setlbl,False,True))
                    elif temp[1] == '|': data.append(silenWindowOpt(self.addwait,30))
                    elif temp[1] == '.': data.append(silenWindowOpt(self.addwait,8))
                    elif temp[1] == '^': data.append(silenWindowOpt(self.close,True))
                elif temp[0] == ':': #: commands
                    if temp[1] == 'c': self.textcolor = self.cstack.pop(); data.append(silenWindowOpt(self.settextcolor,self.textcolor,True))
                    elif temp[1] == 's': self.delay = self.sstack.pop(); data.append(silenWindowOpt(self.setdelay,self.delay,True))
                    elif temp[1] == ',': data.append(silenWindowOpt(self.setlbl,True,True))
            else: data.append(silenWindowText(self,pprtxt[i])) #even ix, string of unimportant (basic) text
        #print '----------------------------------'
        #for ob in data: print ob,ob.text
        #print '----------------------------------'
        return data
    def collapsetext(self,data): return ''.join([ob.text for ob in data]) #this is the full unformatted text string
    def settextcolor(self,color): self.textcolor = color
    def setdelay(self,delay): self.delay = delay
    def addwait(self,wait): self.wait += wait
    def setlbl(self,lbl): self.lbl = lbl
    """
    def setoption(self,textcolor,activecolor,optionlist): #makes the window an option window.
        for i in len(optionlist):
            tempsurf = self.font.render(optionlist[i],False,textcolor)
            self.blit(
        self.text.append
    """
    #def getoption(self):
"""
if __name__ == '__main__':
    i = 30
    #len(i)
    try: (pt,w,h) = i
    except TypeError: pt = i; w = h = 0
    print pt,i,w,h
"""
if __name__ == '__main__':
    #textre = re.compile(r'((?:\\(?:(?:(?:c|s|w)\[.+?\])|(?:\||\.|^|,|\\|:)))|(?::(?:c|s|,)))',re.I)
    #textre = re.compile(r'(?:\\(?:(?:(?:c)\[.+?\])|(?:\.)))|(?::(?:c))',re.I)
    #x = textre.split(r'\c[#00FF0F]This text is not special\..\..\..:c')
    #print x; temp = x[1]
    #print temp[0], temp[1], temp[2], temp[0] == '\\', temp[1] == 'c', (int(temp[4:6],16),int(temp[6:8],16),int(temp[8:10],16))
    wintest = silenWindow(320,240,30,(0,0,128),(0,255,0),"This is letter-by-letter text!\n"
                                                         "On multiple lines!!!!\n"
                                                         "/c[#00FFFF]With color!:c\n"
                                                         "And p/.a/.u/.s/.e/|s/w[15]!/^",(255,255,255),None,2)
    from event import *
    event = silenEvent(); clock = pygame.time.Clock()
    while wintest.active:
        event.update()
        screen.fill((0,0,0))
        wintest.update(event)
        screen.blit(wintest.window(),wintest.window.rect)
        pygame.display.flip()
        clock.tick(30)





























