# silen v0.1
import pygame, sys, os, re
from pygame.locals import *
from event import *

pygame.init()
pygame.display.set_caption('CrossShift+')
pygame.mouse.set_visible(0)
size = width, height =  640, 480
#screen = pygame.display.set_mode(size) # create here so Creator class has a video mode to work with
"""
# screen constants & pygame initialization
def load_image(name, colorkey=None):
    fullname = os.path.join('data', name)
    try: image = pygame.image.load(fullname)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    image = image.convert_alpha()
    return image, image.get_rect()
def main():
    game = GameManager()
    while(1): game.loop()
"""
def load_image(name,colorkey=None): #colorkey={None - convert alpha, (R,G,B[,A]) - set colorkey, 0 - do neither)
    fullname = os.path.join('data', name)
    try: image = pygame.image.load(fullname)#name)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    if colorkey == None: image = image.convert_alpha()
    else:
        image = image.convert()
        if colorkey != 0: image.set_colorkey(colorkey)
    return image#, image.get_rect()
"""
class silenEvent:
    def __init__(self):
        self.keydb = {}
        self.fsflag = False
    def getkey(self,key): #get a key from silenEvent, the right way (getkey(key))
        try: return self.keydb[key]
        except KeyError: return False #if key isn't in keydb, it hasn't been pressed
    def reset(self): self.keydb.clear() #effectively set all pressed keys to False
    def runone(self,event): #run a single event
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F1:
                #if self.fstoggle: self.screen = pygame.display.set_mode(size)
                #else: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                self.fsflag = True #handled in silenScreen
            else: self.keydb[event.key] = True #all other keys are handled in self.keydb
        elif event.type == pygame.KEYUP:
            if event.key == pygame.K_ESCAPE or event.key == pygame.K_F1: pass #ignore these keys
            else: self.keydb[event.key] = False #all other keys handled in self.keydb
    def update(self): #loop for all events
        for event in pygame.event.get(): self.runone(event)
"""
class silenCoreVar: #a non-updated optimization for animated values, with faster calcs and quick creation. use as a dict class (class[frame])
    def __init__(self,ftime,dist,animtype):
        #self.animtype = animtype
        #self.start = start
        self.dist = dist
        #self.end = start + dist
        self.ftime = ftime
        if animtype == 0: #linear
            self.famt = self.dist/float(ftime)
            self.lambda1 = lambda frame: frame*self.famt
            self.callret = lambda dummy: self.lambda1
        elif animtype == 1: #smooth start
            self.famt = self.dist/float(ftime**2)
            self.lambda1 = lambda frame: (frame**2)*self.famt
            self.callret = lambda dummy: self.lambda1
        elif animtype == 2: #smooth end
            self.famt = -self.dist/float(ftime**2)
            self.lambda1 = lambda frame: self.famt*((frame-self.ftime)**2)+self.dist
            self.callret = lambda dummy: self.lambda1
        elif animtype == 3: #smooth start & end
            self.famt = 2*self.dist/float(ftime**2)
            self.lambda1 = lambda frame: (frame**2)*self.famt
            self.lambda2 = lambda frame: -self.famt*((frame-self.ftime)**2)+self.dist
            self.callret = lambda frame: (frame <= self.ftime/2) and self.lambda1 or self.lambda2
    def __call__(self,frame=0): return self.callret(frame)(frame)
    def __getitem__(self,frame=0): return self.callret(frame)(frame)
    """
        if self.animtype == 0: return frame*self.famt
        elif self.animtype == 1: return (frame**2)*self.famt
        elif self.animtype == 2: return self.famt*((frame-self.ftime)**2)+self.dist
        elif self.animtype == 3:
            if frame <= self.ftime//2: return self.famt*(frame**2)
            return -self.famt*((frame-self.ftime)**2)+self.dist
    """
class silenLinCtr:
    def __init__(self,maxix,bounce=False,repeat=True,minix=0,startix=0,startdir=1):
        self.max = maxix
        self.min = minix
        self.pos = startix
        self.bounce = bounce
        self.repeat = repeat
        self.active = True
        self.dir = startdir
    def update(self,timestep): #call once per frame, pass amt of time (in frames) that has passed
        if self.active:
            self.pos += timestep*self.dir
            if self.pos >= self.max:
                self.pos = self.max
                if self.bounce: self.dir = -1
                elif self.repeat: self.pos = 0
                else: self.active = False
            if self.pos <= self.min:
                self.pos = self.min
                if self.repeat: self.dir = 1
                else: self.active = False
    def __call__(self): return self.pos
class silenAnimVar: #handles a core var and linear counter together. updated each frame. called directly to get value.
    def __init__(self,ftime,dist,animtype,bounce=False,repeat=True,delay=0.0,tie=None,minix=0,startix=0,startdir=1):
        self.data = silenCoreVar(ftime,dist,animtype)
        self.cframe = silenLinCtr(ftime,bounce,repeat,minix,startix,startdir)
        self.offset = dist
        self.delay = delay #pauses animation until zero. decreased by timestep each frame
        self.tie = tie #a tied silenAnimVar, silenVar, or silenSprite. if not None, this var must wait to update until the tie finishes
        #the higher the level of variable, the more dangerous it is to tie. never tie a sprite's action to itself, or face the infinite loop!
    def update(self,timestep):
        if self.tie != None: #until the tied var is finished, this var waits
            if self.tie.active(): return
            self.tie = None
        if self.delay != 0: #until the start delay is done, wait
            self.delay -= timestep
            if self.delay < 0: self.delay = 0
            return
        self.cframe.update(timestep)
    def __call__(self): return self.data[self.cframe()]
    def active(self): return self.cframe.active
class silenVar: #wrapper for silenAnimVar classes. handles all animvars of a particular var, and updates offset when they finish.
    def __init__(self,start=0):
        self.offset = start
        self.data = []
    def add(self,ftime,dist,animtype=0,bounce=False,repeat=False,delay=0.0,tie=None,minix=0,startix=0,startdir=1):
        coreadd = silenAnimVar(ftime,dist,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        self.data.append(coreadd)
        return coreadd #returns the silenAnimVar created, to make it available to tie to others.
    def __call__(self): return sum([layer() for layer in self.data],self.offset)
    def update(self,timestep=1):
        for layer in self.data:
            layer.update(timestep)
            if not layer.active(): self.offset += layer.offset
        self.data = [layer for layer in self.data if layer.active()]
    def active(self): return (len(self.data) != 0) and True or False
    def cutshort(self,animvar=None): #sets the offset to the closest int reached currently, and clears the specified animvars
        if animvar != None: #update the offset from the one animvar to kill
            try: self.offset += int(self.data.pop( self.data.index(animvar) )()) #add closest int amount reached, and delete entry
            except ValueError: pass #if it can't find the animvar, just ignore
        else: #update the offset from all animvars, then kill them
            for i in range(self.data): self.offset += int(self.data[i]())
            self.data = []
class silenPicDelay: #manages an animated sprite in a larger image
    def __init__(self,times,irect,numwide=1,numhigh=1,wrap=True,startix=0,starttimer=0,minix=0,maxix=None):#,image
        self.ix = startix #position in the list of times (usually leave default)
        self.timer = starttimer #count on the current ix in the list (usually leave default)
        self.list = times #tuple or list of times for delays
        #self.image = image #large image with all anims in it (numwide x numhigh small images)
        self.width = irect.width//numwide
        self.height = irect.height//numhigh
        self.numwide = numwide
        self.wrap = wrap #if list repeats
        self.active = True
        self.minix = minix
        if maxix == None: self.maxix = len(times)
        else: self.maxix = maxix
    def update(self,timestep): #call once per frame, pass amt of time (in frames) that has passed
        if self.active:
            self.timer += timestep
            if self.timer >= self.list[self.ix]:
                self.timer = 0
                self.ix += 1
                if self.ix >= self.maxix:
                    if self.wrap: self.ix = self.minix
                    else: self.active = False
    def __call__(self): #get the rect for the image to display (within the larger image)
        return Rect(self.width*(self.ix%self.numwide),self.height*(self.ix//self.numwide),self.width,self.height)
class silenSprite:
    timestep = 1.0
    def __init__(self,filename,colorkey=None,cxstart=0,cystart=0,alphastart=255):
        self.alldata = load_image(filename,colorkey)
        self.allrect = self.alldata.get_rect()
        self.cx = silenVar(cxstart)
        self.cy = silenVar(cystart)
        self.xscale = silenVar(1.0) #these vars are proportions only, unfortunately
        self.yscale = silenVar(1.0)
        self.rot = silenVar(0.0)
        self.alpha = silenVar(alphastart) #only works with colorkey pictures
        (self.rfill,self.gfill,self.bfill,self.afill) = (silenVar(0),silenVar(0),silenVar(0),silenVar(0))
        self.fill = lambda: (self.rfill(),self.gfill(),self.bfill(),self.afill()) #afill only works on surfaces w/ alpha
        self.svlist = [self.cx,self.cy,self.xscale,self.yscale,self.rot,self.alpha,self.rfill,self.gfill,self.bfill,self.afill]
        self.oldxscale = 1.0
        self.oldyscale = 1.0
        self.oldrot = 0.0
        self.oldalpha = 255
        (self.oldrfill,self.oldgfill,self.oldbfill,self.oldafill) = self.oldfill = (0,0,0,0) #same ref, meaning changing one will affect the other (as it should)
        self.data = None
        self.rect = None
        self.pdelay = None
        self.changepic(True)
    def active(self): #if the sprite needs to be updated, this will return true.
        for var in self.svlist:
            if var.active(): return True
        return False
    def makeanim(self,times,numwide=1,numhigh=1,wrap=True,startix=0,starttimer=0,minix=0,maxix=None):
        self.pdelay = silenPicDelay(times,self.allrect,numwide,numhigh,wrap,startix,starttimer,minix,maxix)
        self.changepic(True)
    def changepic(self,recalc=False): #after running, self.data will contain the surface to blit, and self.rect will contain its position respective to self.cx and self.cy
        (rot,rotflag) = (self.rot(),False)
        (xs,ys,scaleflag) = (self.xscale(),self.yscale(),False)
        (alpha,alphaflag) = (self.alpha(),False)
        (fill,fillflag) = (self.fill(),False)
        if rot != self.oldrot: (self.oldrot,rotflag) = (rot,True)
        if xs != self.oldxscale or ys != self.oldyscale: (self.oldxscale,self.oldyscale,scaleflag) = (xs,ys,True)
        if alpha != self.oldalpha: (self.oldalpha,alphaflag) = (alpha,True)
        if fill != self.oldfill: (self.oldfill,fillflag) = (fill,True)
        if fillflag: self.data.fill(fill)
        elif rotflag or scaleflag or alphaflag or recalc: #surface update is necessary
            if self.pdelay != None: self.data = self.alldata.subsurface(self.pdelay())
            else: self.data = self.alldata
            if xs < 0 or ys < 0: self.data = pygame.transform.flip(self.data,(xs<0),(ys<0))
            temprect = self.data.get_rect()
            self.data = pygame.transform.scale(self.data,(int(abs(xs)*temprect.width),int(abs(ys)*temprect.height))) #scales by width,height
            if rot%360 != 0: self.data = pygame.transform.rotate(self.data,rot)
            if alpha != 255: self.data.set_alpha(alpha)
        temprect = self.data.get_rect()
        self.rect = Rect(self.cx() - temprect.w/2, self.cy() - temprect.h/2, temprect.w, temprect.h)
    def changetimestep(self,timestep=1.0): self.__class__.timestep = timestep
    def update(self):
        for var in self.svlist: var.update(self.__class__.timestep)
        if self.pdelay != None: self.pdelay.update(self.__class__.timestep)
        self.changepic()
    def __call__(self): return self.data #should always contain the graphic to draw
    def area_rect(self): return self.pdelay != None and self.pdelay() or None
    def setpos(self,cx,cy): (self.cx.offset,self.cy.offset) = (cx,cy) #set the center position of the sprite absolutely
    def setposo(self,cx,cy): #set the center position of the sprite, relative to the current position
        self.cx.offset += cx
        self.cy.offset += cy
    def movepos(self,cxamt,cyamt,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        avcx = self.cx.add(time,cxamt,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        avcy = self.cy.add(time,cyamt,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        return (avcx,avcy)
    def rotate(self,cwdegs,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        return self.rot.add(time,cwdegs,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
    def fadein(self,time,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        (self.alpha.offset,self.alpha.data) = (0,[])
        return self.alpha.add(time,255,0,bounce,repeat,delay,tie,minix,startix,startdir)
    def fadeout(self,time,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        (self.alpha.offset,self.alpha.data) = (255,[])
        return self.alpha.add(time,0,0,bounce,repeat,delay,tie,minix,startix,startdir)
    def scale(self,xprop,yprop,time,animtype=0,delay=0.0,tie=None,bounce=False,repeat=False,minix=0,startix=0,startdir=1):
        avxp = self.xscale.add(time,xprop,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        avyp = self.yscale.add(time,yprop,animtype,bounce,repeat,delay,tie,minix,startix,startdir)
        return (avxp,avyp)
def main():
    screen = pygame.display.set_mode(size)
    startscreen = [silenSprite('bluegradient.png',0,320,240),silenSprite('cutscenebars.png',None,320,240),silenSprite('shifttext.png',None,720,240),
                   silenSprite('crosstoppt.png',None,320,90),silenSprite('crossleftpt.png',None,120,240),silenSprite('crossbotpt.png',None,320,400),
                   silenSprite('cross.png',(68,178,142),472,295,0),silenSprite('start.png',(68,178,142),473,295,0)]
    startscreen[0].fadein(30)
    (startscreen[1].rot.offset, startscreen[1].xscale.offset, startscreen[1].yscale.offset) = (15.0, 2.0, 2.0)
    startscreen[1].rotate(-15.0,15,2,0.0,startscreen[0])
    startscreen[1].scale(-1.0,-1.0,15,2,0.0,startscreen[0])
    startscreen[2].movepos(-100,0,7,2,0.0, startscreen[2].movepos(-50,0,45,0,0.0, startscreen[2].movepos(-250,0,20,1,15.0,startscreen[1])[0] )[0] )
    startscreen[3].movepos(0,150,10,2,0.0,startscreen[2])
    startscreen[4].movepos(200,0,10,2,0.0,startscreen[3])
    startscreen[5].movepos(0,-160,10,2,0.0,startscreen[4])
    startscreen[6].rotate(360.0,15,2,5.0,startscreen[5])
    startscreen[6].fadein(15,5.0,startscreen[5])
    clock = pygame.time.Clock()
    event = silenEvent()
    screenfsflag = False
    while startscreen[6].active():
        event.update()
        if event.fsflag:
            (event.fsflag,screenfsflag) = (False,not screenfsflag)
            if screenfsflag: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            else: screen = pygame.display.set_mode(size)
        screen.fill((0,0,0))
        for sprite in startscreen:
            sprite.update()
            screen.blit(sprite(),sprite.rect,sprite.area_rect())
        pygame.display.flip()
        clock.tick(30)
    startscreen[7].fadein(45,15.0,None,True,True)
    while 1:
        event.update()
        if event.fsflag:
            (event.fsflag,screenfsflag) = (False,not screenfsflag)
            if screenfsflag: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            else: screen = pygame.display.set_mode(size)
        screen.fill((0,0,0))
        for sprite in startscreen:
            sprite.update()
            screen.blit(sprite(),sprite.rect,sprite.area_rect())
        pygame.display.flip()
        clock.tick(30)
    raise SystemExit()
if __name__ == '__main__': main()
"""    test = silenAnimVar(25,100,3)
    print test()
    for i in range(25):
        test.update(1)
        print test()
    test2 = silenLinCtr(5,True)
    print test2()
    for i in range(26):
        test2.update(1)
        print test2()
    test3 = silenPicDelay([1,2,3,4,5,6,1,1,1],Rect(0,0,96,96),3,3)
    print '\n',test3()
    for i in range(26):
        test3.update(1)
        print test3()
    test4 = silenVar(50)
    test4.add(25,100,3)
    print test4()
    for i in range(25):
        test4.update()
        print test4()
    raise SystemExit()
"""
"""
    pygame.init()
    pygame.display.set_caption('silen v0.1')
    pygame.mouse.set_visible(0)
    size = width, height =  640, 480
    screen = pygame.display.set_mode(size) # create here so events work
"""
"""
for event in pygame.event.get():
    if event.type == pygame.KEYDOWN:
        print event.key
        if event.key == pygame.K_ESCAPE: raise SystemExit()
"""

"""
class Creator:
    def __init__(self):
        self.dirt_img, self.dirt_img_rect = load_image("dirt.png")
        self.turret_img, self.turret_img_rect = load_image("flamethrower.png")
        self.turret_img_r, self.turret_img_rect_r = load_image("flamethrower_r.png")
        self.wall_img, self.wall_img_rect = load_image("brick.png")
        self.goal_img, self.goal_img_rect = load_image("target.png")
        self.grass_img, self.grass_img_rect = load_image("grass.png")
    def __call__(self, value):
        if value == "1": return GrassBlock(self.grass_img)
        elif value == "2": return WallBlock(self.wall_img)
        elif value == "3": return DirtBlock(self.dirt_img)
        elif value == "5": return TurretBlock(self.turret_img,1)
        elif value == "6": return TurretBlock(self.turret_img_r,-1)
        elif value == "7": return GoalBlock(self.goal_img)
        elif int(value) >= 10: return TrapBlock(self.dirt_img,self.wall_img,int(value))
        else: return EmptyBlock() #value == "0" or invalid
create_block = Creator()
class Grid:
    def __init__(self, file_name):
        self.valid = True
        self.move_counter = 0
        self.move_digtime = 0
        self.move_x = 0
        self.move_y = 0
        self.move_direction = -1
        self.still_alive = True
        self.win = False
        self.timer = -1
        self.real_x = 0
        self.real_y = 0
        self.width = 20
        self.height = 15
        self.settimer = 900
        self.rows = []
        # intitialize map
        try: fd = open(os.path.join("data",file_name))
        except IOError:
            self.valid = False
            return
        regread = re.compile(r"\d+") # any number of numeric characters (greedy)
        line = fd.readline()
        data = regread.findall(line) # ignore any amount of whitespace and text in first line
        if len(data) < 2: # first line should have width, height, and (possibly) timer frames
            self.valid = False
            return
        self.width = int(data[0])
        self.height = int(data[1])
        if len(data) >= 3: self.settimer = int(data[2])
        data = []
        for i in range(self.height):
            line = fd.readline()
            data = regread.findall(line) # ignore any amount of whitespace and text in file
            if len(data) < self.width: # if there aren't enough numbers in the line, quit
                self.valid = False
                return
            row = [create_block(data[j]) for j in range(self.width)]
            self.rows.append(row)
    def draw(self, screen):
        y = 240 - self.real_y
        ypos = 0
        for row in self.rows:
            x = 320 - self.real_x
            xpos = 0
            for block in row:
                block.draw(screen, x, y)
                if block.is_active() and block.get_facing() == -1:
                    if ypos == int((self.real_y+16)/32) and  xpos - 3 <= int((self.real_x+16)/32) and int((self.real_x+16)/32) <= xpos:
                        self.still_alive = False
                        return
                if block.is_active() and block.get_facing() == 1:
                    if ypos == int((self.real_y+16)/32) and  xpos <= int((self.real_x+16)/32) and int((self.real_x+16)/32) <= xpos + 3:
                        self.still_alive = False
                        return
                xpos += 1
                x += 32
            ypos += 1
            y += 32
        draw_shroud(screen)
        row = self.rows[0]
        y = 240 - self.real_y
        x = 320 - self.real_x
        for block in row:
            block.draw(screen, x, y)
            x += 32
        if self.timer != -1:
            my_font = pygame.font.Font('data/quartzitalic.ttf',64)
            if (self.timer%30)*2 < 10: screen.blit(my_font.render('%i:0%i' % (self.timer/30, (self.timer%30)*2),True,(0,255,0)),(0,0))
            else: screen.blit(my_font.render('%i:%i' % (self.timer/30, (self.timer%30)*2),True,(0,255,0)),(0,0))
    def update(self):
        if self.timer != -1:
            if self.real_y == 0:
                self.win = True
                return
            elif self.timer == 0:
                self.still_alive = False
                return
            else: self.timer -= 1
        elif self.rows[int(self.real_y/32)][int(self.real_x/32)].is_goal() and self.timer == -1: self.timer = self.settimer
        if self.move_digtime > 1: self.move_digtime -=1
        elif self.move_digtime == 1: # kill block
            self.move_digtime = 0
            if self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)].is_trap():
                for row in self.rows:
                    for curblock in row:
                        if curblock.is_trap() and self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)].trapnum == curblock.trapnum:
                            curblock.triggered = True
            elif self.real_y+self.move_y*4 == 0: self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)] = create_block("1")
            else: self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)] = EmptyBlock()
        elif self.move_counter > 0: # fluid movement
            #(add_x,add_y) = (int(self.move_x/self.move_counter),int(self.move_y/self.move_counter))
            #(self.move_x,self.move_y)=(self.move_x-add_x,self.move_y-add_y)
            (self.real_x,self.real_y)=(self.real_x+self.move_x,self.real_y+self.move_y)
            self.move_counter -=1
        return
    def is_passable(self,x,y): return x >= 0 and x < self.width and y >= 0 and y < self.height and self.rows[y][x].is_passable()
    def is_diggable(self,x,y): return x >= 0 and x < self.width and y >= 0 and y < self.height and self.rows[y][x].is_diggable()
    def move(self,delta_x,delta_y):
        if self.move_counter == 0:
            target_x = int(self.real_x/32) + delta_x
            target_y = int(self.real_y/32) + delta_y
            if self.is_passable(target_x,target_y): (self.move_x,self.move_y,self.move_counter) = (delta_x*8,delta_y*8,4)
            elif self.is_diggable(target_x,target_y): (self.move_x,self.move_y,self.move_counter,self.move_digtime) = (delta_x*8,delta_y*8,4,3)
    def cancel_move(self):
        if(self.move_digtime > 0): (self.move_digtime,self.move_counter) = (0,0)
class Digger:
    def __init__(self):
        self.x = 0
        self.y = 0
        self.img, self.img_rect = load_image("test.png")
        self.grass_img, self.grass_img_rect = load_image("snake_grass.png")
    def draw(self, screen):
        screen.blit(self.img,(320+self.x*32,240+self.y*32))
def lose(screen):
    #print "LOSE"
    lose_img, lose_img_rect = load_image("lose.png")
    screen.blit(lose_img,(0,0))
def win(screen):
    #print "WIN"
    img, img_rect = load_image("win.png")
    screen.blit(img,(0,0))
def intro(screen):
    #print "WIN"
    img, img_rect = load_image("intro.png")
    screen.blit(img,(0,0))
def draw_shroud(screen):
    img, img_rect = load_image("fow.png")
    screen.blit(img,(0,0))
def build_level(level):
    return Grid("Level%s.txt" % level)
class GameManager:
    def __init__(self):
        self.start = False
        self.screen = pygame.display.set_mode(size)
        self.black = 0, 0, 0
        self.fstoggle = False
        self.background, self.background_rect = load_image("black.png")
        self.clock = pygame.time.Clock()
        self.keydown = [False,False,False,False]
        self.timer = 0
        self.score = 0
        self.level = 1
        self.player = Digger()
        self.move_counter = 0
        self.grid = None
        self.skipintro = False
        self.screen.blit(self.background, (0, 0))
        pygame.display.flip()
        pygame.mixer.init()
        pygame.mixer.music.load('data/UndergroundMix.mp3')
        pygame.mixer.music.play(-1)
    def common_events(self,event):
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F1:
                if self.fstoggle: self.screen = pygame.display.set_mode(size)
                else: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                self.fstoggle = not self.fstoggle
                return True
        return False
    def loop(self):
        while not self.start and not self.skipintro:
            intro(self.screen)
            pygame.display.flip()
            self.clock.tick(30)
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_c: self.start = True # continue
                    else: (self.level,self.start) = (1,True) # restart
        self.skipintro = False
        self.grid = build_level(self.level)
        if not self.grid.valid: raise SystemExit() # finished the available levels
        while self.grid.still_alive and not self.grid.win:
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key >= 273 and event.key <= 276: self.keydown[event.key-273] = True # arrow keys
                elif event.type == pygame.KEYUP:
                    if event.key >= 273 and event.key <= 276:
                        self.keydown[event.key-273] = False # arrow keys
                        self.grid.cancel_move()
            if self.keydown[0]: self.grid.move(0,-1)
            elif self.keydown[1]: self.grid.move(0,1)
            elif self.keydown[2]: self.grid.move(1,0)
            elif self.keydown[3]: self.grid.move(-1,0)
            self.clock.tick(30)
            self.screen.blit(self.background, (0,0))
            self.grid.update()
            self.grid.draw(self.screen)
            self.player.draw(self.screen)
            pygame.display.flip()
        self.keydown = [False,False,False,False] # incase player was holding down a key when they died
        self.start = False
        while not self.start:
            self.clock.tick(30)
            if self.grid.win: win(self.screen)
            else: lose(self.screen)
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_c: (self.start,self.skipintro) = (True,True) # continue
                    else: self.start = True
            pygame.display.flip()
        if self.grid.win: self.level += 1
        else: self.start = False
"""
