# silen v0.1
import pygame, sys, os, re, array, numpy
from pygame.locals import *

# screen constants & pygame initialization
pygame.init()
pygame.display.set_caption('silen v0.1 - mapMaker')
pygame.mouse.set_visible(0)
size = (640,480)
screen = pygame.display.set_mode(size) # create here so Creator class has a video mode to work with
def load_image(name,colorkey=None):
    #fullname = os.path.join('data', name)
    try: image = pygame.image.load(name)#fullname)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    if colorkey == None: image = image.convert_alpha()
    else:
        image = image.convert()
        image.set_colorkey(colorkey)
    return image#, image.get_rect()
class silenEvent:
    def __init__(self):
        self.keydb = {}
        self.fsflag = False
    def getkey(self,key): #get a key from silenEvent, the right way (getkey(key))
        if key in self.keydb: return self.keydb[key] and True or False #maintains validity of result, even with ints in dictionary
        return False #if key isn't in keydb, it hasn't been pressed
    def getkeyu(self,key): #getkey and untrigger it immediately
        if key in self.keydb:
            if self.keydb[key]:
                self.keydb[key] = False
                return True
        return False
    def getkeyd(self,key,x): #getkey with delay, only returns true every x times queried
        if key in self.keydb:
            if self.keydb[key]:
                self.keydb[key] -= 1 #since True==1 and False==0, this works initially
                if not self.keydb[key]: #False means timer has counted down to 0
                    self.keydb[key] = x #restart timer
                    return True
        return False
    def getkeys(self,keylist): #get a list of keys, returning True if any are pressed
        for key in keylist:
            if key in self.keydb and self.keydb[key]: return True
        return False
    def getkeysu(self,keylist): #get a list of keys and untrigger all, then return True if any were pressed
        rtn = False
        for key in keylist:
            if key in self.keydb:
                if self.keydb[key]:
                    self.keydb[key] = False
                    rtn = True
        return rtn
    #def getkeysd(self,keylist,x): #get a list of keys, updating all delays to x if True, then return True if any were pressed
    #def getfkey(self,keylist): #same as getkeys, but returns first key in set that was True, or None
    def getfkeyu(self,keylist): #same as getkeysu, but returns first key in set that was True, or None
        rtn = None
        for key in keylist:
            if key in self.keydb:
                if self.keydb[key]:
                    self.keydb[key] = False
                    rtn = key
        return rtn
    #def getfkeyd(self,keylist,x): #same as getkeysd, but returns first key in set that was True, or None
    def untrigger(self,key): self.keydb[key] = False
    def trigger(self,key): self.keydb[key] = True
    def reset(self): #effectively sets all pressed keys to False, and clears event stack
        self.keydb.clear()
        pygame.event.get()
    def runone(self,event): #run a single event
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F12:
                #if self.fstoggle: self.screen = pygame.display.set_mode(size)
                #else: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                self.fsflag = True #handled in silenScreen
            else: self.keydb[event.key] = True #all other keys are handled in self.keydb
        elif event.type == pygame.KEYUP:
            if event.key == pygame.K_ESCAPE or event.key == pygame.K_F12: pass #ignore these keys
            else: self.keydb[event.key] = False #all other keys handled in self.keydb
    def update(self): #loop for all events
        for event in pygame.event.get(): self.runone(event)
class silenMap:
    def __init__(self,fname,ifname):
        self.data = array.array('B')
        try:
            fd = open(os.path.join("data",fname),"rb")
            width = fd.read(1)
            height = fd.read(1)
            self.data.fromfile(fd,width*height)
        finally: fd.close()
class silenMapMaker:
    def __init__(self):#self.valid = True
        print "----- silen Map Maker v1.0 -----"
        print "_________"
        print "Controls:| Arrow keys: move cursor  |  Escape: Quit"
        print "~~~~~~~~~  Space, Enter: place current block"
        print "             (hold and move to place more than one)"
        print "  Z: Select current collision tile to draw"
        print "     (within, use arrows to move and Z, Space, or Enter to select)"
        print "  0-9: Select layer to work on (0 is collision layer)."
        print "  F1: Change mapID, number of layers, and player draw position"
        print "  F2: Toggle displaying collision layer on top"
        print "  F3: Resize map  [] | (extend from BR corner/crop to UL corner)"
        print "                  |__|"
        print "  F4: Resize map  |  | (extend from UL corner/crop to BR corner)"
        print "                  |_[]"
        print "  F5: Save current map data (make sure to include extension .map)"
        print "  F8: Open map data from a file (include extension .map)"
        print "  F12: Toggle between fullscreen and windowed modes"
        print "------------------------------------------------------------------"
        print "NOTE: F1, F3, F4, F5, and F8 use the console window for input."
        self.regread = re.compile(r"\d+") # any number of numeric characters (greedy)
        (self.width,self.height) = (20,15)
        self.coldata = []
        self.coldata.append(numpy.zeros((self.width,self.height),numpy.int_)) #coldata[layer][width][height]
        (self.posx,self.posy,self.number,self.layer) = (0,0,0,0)
        self.colpic = load_image("collision.png",(255,255,255))
        self.curpic = load_image("cursor.png")
        self.mappic = load_image("map00.png")
        self.mapmax = min(256,8*(self.mappic.get_height()//32))
        self.clock = pygame.time.Clock()
        (self.dispcol,self.selcol) = (True,False)
        (self.mapid,self.layers,self.ppos) = (0,1,0)
    def modlayers(self): #modify the map id, the number of map layers, and the player draw position
        dim = raw_input("(%d,%d,%d) = map id, #layers, and ppos. Change to: " % (self.mapid,self.layers,self.ppos))
        data = self.regread.findall(dim)
        if len(data) < 3: return
        (self.mapid,newlayers,self.ppos) = (int(data[0]),int(data[1]),int(data[2]))
        self.mappic = load_image("map%02d.png" % (self.mapid))
        self.mapmax = min(256,8*(self.mappic.get_height()//32))
        if newlayers > self.layers:
            for i in range(newlayers - self.layers): self.coldata.append(numpy.zeros((self.width,self.height),numpy.int_))
        elif newlayers < self.layers: self.coldata = self.coldata[:newlayers]
        self.layers = newlayers
    def resize(self): #extend from the bottom right corner/crop to the upper left corner
        dim = raw_input("(%d,%d) = width, height. Change to: " % (self.width,self.height))
        data = self.regread.findall(dim)
        if len(data) < 2: return
        (newwidth,newheight) = (int(data[0]),int(data[1]))
        for lyr in range(len(self.coldata)):
            if newwidth > self.width:
                temparray = numpy.zeros((newwidth - self.width,self.height),numpy.int_)
                self.coldata[lyr] = numpy.vstack((self.coldata[lyr],temparray))
            elif newwidth < self.width: self.coldata[lyr] = numpy.vsplit(self.coldata[lyr],(newwidth,))[0]
        self.width = newwidth
        for lyr in range(len(self.coldata)):
            if newheight > self.height:
                temparray = numpy.zeros((self.width,newheight - self.height),numpy.int_)
                self.coldata[lyr] = numpy.hstack((self.coldata[lyr],temparray))
            elif newheight < self.height: self.coldata[lyr] = numpy.hsplit(self.coldata[lyr],(newheight,))[0]
        self.height = newheight
        if self.posx >= self.width: self.posx = self.width - 1
        if self.posy >= self.height: self.posy = self.height - 1
    def resize2(self): #extend from the upper left corner/crop to the bottom right corner
        dim = raw_input("(%d,%d) = width, height. Change to: " % (self.width,self.height))
        data = self.regread.findall(dim)
        if len(data) < 2: return
        (newwidth,newheight) = (int(data[0]),int(data[1]))
        for lyr in range(len(self.coldata)):
            if newwidth > self.width:
                temparray = numpy.zeros((newwidth - self.width,self.height),numpy.int_)
                self.coldata[lyr] = numpy.vstack((temparray,self.coldata[lyr]))
            elif newwidth < self.width: self.coldata[lyr] = numpy.vsplit(self.coldata[lyr],(self.width - newwidth,))[1]
        self.posx += newwidth - self.width
        self.width = newwidth
        for lyr in range(len(self.coldata)):
            if newheight > self.height:
                temparray = numpy.zeros((self.width,newheight - self.height),numpy.int_)
                self.coldata[lyr] = numpy.hstack((temparray,self.coldata[lyr]))
            elif newheight < self.height: self.coldata[lyr] = numpy.hsplit(self.coldata[lyr],(self.height - newheight,))[1]
        self.posy += newheight - self.height
        self.height = newheight
        if self.posx < 0: self.posx = 0
        if self.posy < 0: self.posy = 0
    def save(self): #save data in format silenMap uses
        fname = raw_input("Save to [filename.map]: ")
        try:
            fileobj = open(fname,"wb")
            try:
                out = array.array('B')
                out.fromlist([self.width,self.height,self.mapid,self.layers,self.ppos])
                for lyr in range(self.layers): out.fromlist([elem for elem in self.coldata[lyr].ravel()])
                out.tofile(fileobj)
                print "Successfully written to \"%s\"" % (fname)
            finally: fileobj.close()
        except IOError: print "Could not create \"%s\". Save failed." % (fname)
    def openexisting(self): #open a silenMap format map file
        fname = raw_input("Open [filename.map]: ")
        try:
            fileobj = open(fname,"rb")
            try:
                fin = array.array('B')
                fin.fromfile(fileobj,5)
                (self.width,self.height,self.mapid,self.layers,self.ppos)=(fin[0],fin[1],fin[2],fin[3],fin[4])
                print "Loading a %sx%s map with %s layers..." % (self.width,self.height,self.layers)
                self.coldata = []
                for lyr in range(self.layers):
                    fin = array.array('B')
                    fin.fromfile(fileobj,self.width*self.height)
                    self.coldata.append(numpy.array(fin.tolist(),numpy.int_).reshape(self.width,self.height))
                #print self.coldata[0]
                (self.posx,self.posy,self.number,self.layer) = (0,0,0,self.layers - 1)
                (self.dispcol,self.selcol) = (True,False)
                self.mappic = load_image("map%02d.png" % (self.mapid))
                self.mapmax = min(256,8*(self.mappic.get_height()//32))
                print "Successfully loaded \"%s\"" % (fname)
            finally: fileobj.close()
        except IOError: print "\"%s\" does not exist in the current directory. Open failed." % (fname)
    def update(self,event):
        if self.selcol:
            if self.layer:
                if event.getkeyd(pygame.K_LEFT,4):
                    if self.number > 0 and self.number%8 != 0: self.number -= 1
                if event.getkeyd(pygame.K_RIGHT,4):
                    if self.number < self.mapmax - 1 and self.number%8 != 7: self.number += 1
                if event.getkeyd(pygame.K_UP,4):
                    if self.number > 7: self.number -= 8
                if event.getkeyd(pygame.K_DOWN,4):
                    if self.number < self.mapmax - 8: self.number += 8
                if event.getkeysu([pygame.K_z,pygame.K_RETURN,pygame.K_SPACE]):
                    self.selcol = False
                    event.reset()
            else:
                if event.getkeyd(pygame.K_LEFT,4):
                    if self.number > 0 and self.number%4 != 0: self.number -= 1
                if event.getkeyd(pygame.K_RIGHT,4):
                    if self.number < 31 and self.number%4 != 3: self.number += 1
                if event.getkeyd(pygame.K_UP,4):
                    if self.number > 3: self.number -= 4
                if event.getkeyd(pygame.K_DOWN,4):
                    if self.number < 28: self.number += 4
                if event.getkeysu([pygame.K_z,pygame.K_RETURN,pygame.K_SPACE]):
                    self.selcol = False
                    event.reset()
        else:
            if event.getkeyd(pygame.K_LEFT,4):
                if self.posx > 0: self.posx -= 1
            if event.getkeyd(pygame.K_RIGHT,4):
                if self.posx < self.width - 1: self.posx += 1
            if event.getkeyd(pygame.K_UP,4):
                if self.posy > 0: self.posy -= 1
            if event.getkeyd(pygame.K_DOWN,4):
                if self.posy < self.height - 1: self.posy += 1
            if event.getkeys([pygame.K_RETURN,pygame.K_SPACE]): self.coldata[self.layer][self.posx][self.posy] = self.number
            layerchange = event.getfkeyu(range(pygame.K_1,pygame.K_9+1))
            if layerchange != None:
                newlayer = layerchange - pygame.K_0
                if newlayer < self.layers and newlayer != self.layer:
                    if not self.layer: self.number = 0
                    self.layer = newlayer
            if event.getkeyu(pygame.K_0) and self.layer: (self.number,self.layer) = (0,0)
            if event.getkeyu(pygame.K_z):
                self.selcol = True
                event.reset()
            if event.getkeyu(pygame.K_F1):
                self.modlayers()
                event.reset()
            if event.getkeyu(pygame.K_F2): self.dispcol = not self.dispcol
            if event.getkeyu(pygame.K_F3):
                self.resize()
                event.reset()
            if event.getkeyu(pygame.K_F4):
                self.resize2()
                event.reset()
            if event.getkeyu(pygame.K_F5):
                self.save()
                event.reset()
            if event.getkeyu(pygame.K_F8):
                self.openexisting()
                event.reset()
        self.draw()
    def __call__(self,x,y): return Rect(32*(self.coldata[self.layer][x][y]%4),32*(self.coldata[self.layer][x][y]//4),32,32)
    def draw(self):
        screen.fill((0,0,255))
        if self.selcol:
            if self.layer: screen.blit(self.mappic,(320-32*(self.number%8),224-32*(self.number//8)))
            else: screen.blit(self.colpic,(320-32*(self.number%4),224-32*(self.number//4)))
        else:
            (y,ypos) = (0,self.posy-7)
            for j in range(15):
                (x,xpos) = (0,self.posx-10)
                for i in range(20):
                    if ypos >= 0 and ypos < self.height and xpos >=0 and xpos < self.width:
                        screen.fill((255,255,255),Rect(x,y,32,32))
                        if self.layer: # map layer display
                            for lyr in range(1,self.layer+1):
                                r = Rect(32*(self.coldata[lyr][xpos][ypos]%8),32*(self.coldata[lyr][xpos][ypos]//8),32,32)
                                if lyr - 1 == self.ppos and not self.dispcol and ypos == self.posy and xpos == self.posx:
                                    screen.blit(self.curpic,(x,y),Rect(32,0,32,32))
                                screen.blit(self.mappic,(x,y),r)
                            if self.dispcol:
                                r = Rect(32*(self.coldata[0][xpos][ypos]%4),32*(self.coldata[0][xpos][ypos]//4),32,32)
                                self.colpic.set_alpha(128)
                                screen.blit(self.colpic,(x,y),r)
                                self.colpic.set_alpha(255)
                        else: # collision layer display
                            for lyr in range(1,self.layers):
                                r = Rect(32*(self.coldata[lyr][xpos][ypos]%8),32*(self.coldata[lyr][xpos][ypos]//8),32,32)
                                screen.blit(self.mappic,(x,y),r)
                            r = Rect(32*(self.coldata[0][xpos][ypos]%4),32*(self.coldata[0][xpos][ypos]//4),32,32)
                            screen.blit(self.colpic,(x,y),r)
                    xpos += 1
                    x += 32
                ypos += 1
                y += 32
            """
            (y,ypos) = (0,self.posy-7)
            for j in range(15):
                (x,xpos) = (0,self.posx-10)
                for i in range(20):
                    if ypos >= 0 and ypos < self.height and xpos >=0 and xpos < self.width:
                        if self.layer:
                            r = Rect(32*(self.coldata[self.layer][xpos][ypos]%8),32*(self.coldata[self.layer][xpos][ypos]//8),32,32)
                            screen.fill((255,255,255),Rect(x,y,32,32))
                            screen.blit(self.mappic,(x,y),r)
                        else:
                            r = Rect(32*(self.coldata[0][xpos][ypos]%4),32*(self.coldata[0][xpos][ypos]//4),32,32)
                            screen.blit(self.colpic,(x,y),r)
                    xpos += 1
                    x += 32
                ypos += 1
                y += 32
            """
        screen.blit(self.curpic,(320,224),Rect(0,0,32,32))
        self.clock.tick(30)#59 fps w/ std. 4-layer map
        #fps = self.clock.get_fps()
        #pygame.display.set_caption("silen v0.1 - mapMaker - %fFPS" % (fps))
        pygame.display.flip()
if __name__ == '__main__':# main()
    mapmkr = silenMapMaker()
    event = silenEvent()
    fstoggle = False
    while 1:
        event.update()
        if event.fsflag:
            event.fsflag = False
            if fstoggle: screen = pygame.display.set_mode(size)
            else: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            fstoggle = not fstoggle
        mapmkr.update(event)
    raise SystemExit()
"""
    nar = numpy.arange(1,5)
    print nar
    testfile = open(os.path.join("mapdata","test.map"),"wb")
    #testfile.write('%x' % (1))
    out = array.array('B')
    out.fromlist([elem for elem in nar.flat])
    print out
    out.tofile(testfile)
    testfile.close()
    additdata = array.array('B')
    try:
        fd = open(os.path.join("mapdata","test.map"),"rb")
        additdata.fromfile(fd,2)
        print additdata[0], additdata[1]
    finally: fd.close()
    raise SystemExit()
    pygame.init()
    pygame.display.set_caption('silen v0.1')
    pygame.mouse.set_visible(0)
    size = width, height =  640, 480
    screen = pygame.display.set_mode(size) # create here so events work
    while(1):
        event.update()
        if event.fsflag:
            event.fsflag = False
            if fstoggle: screen = pygame.display.set_mode(size)
            else: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            fstoggle = not fstoggle
"""
