# silen v0.1
import pygame, sys, os, re, array, numpy, math
from pygame.locals import *

# screen constants & pygame initialization
"""
pygame.init()
pygame.display.set_caption('FIRE IN THE HOLE!!!')
pygame.mouse.set_visible(0)
size = width, height =  640, 480
screen = pygame.display.set_mode(size) # create here so Creator class has a video mode to work with
"""
def load_image(name, colorkey=None):
    fullname = os.path.join('data', name)
    try: image = pygame.image.load(fullname)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    image = image.convert_alpha()
    return image#, image.get_rect()
class silenEvent:
    def __init__(self):
        self.keydb = {}
        self.fsflag = False
    def getkey(self,key): #get a key from silenEvent, the right way (getkey(key))
        try: return self.keydb[key]
        except KeyError: return False #if key isn't in keydb, it hasn't been pressed
    def reset(self): self.keydb.clear() #effectively set all pressed keys to False
    def runone(self,event): #run a single event
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F1:
                #if self.fstoggle: self.screen = pygame.display.set_mode(size)
                #else: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                self.fsflag = True #handled in silenScreen
            else: self.keydb[event.key] = True #all other keys are handled in self.keydb
        elif event.type == pygame.KEYUP:
            if event.key == pygame.K_ESCAPE or event.key == pygame.K_F1: pass #ignore these keys
            else: self.keydb[event.key] = False #all other keys handled in self.keydb
    def update(self): #loop for all events
        for event in pygame.event.get(): self.runone(event)
class silenContactRegion:
    def __init__(self,rect,ptype = 'out'):
        self.rect = rect #UL corner of rect should be relative to object pos (xoffset,yoffset,width,height)
        (self.posx,self.posy,self.oldposx,self.oldposy,self.xw,self.yw) = (rect.centerx,rect.centery,rect.centerx,rect.centery,rect.w/2,rect.h/2)
        if ptype == 'out': self.ptest = [True,True,True,True]
        elif ptype == 'out side': self.ptest = [False,False,True,True]
        elif ptype == 'up': self.ptest = [True,False,False,False]
        elif ptype == 'down': self.ptest = [False,True,False,False]
        elif ptype == 'right': self.ptest = [False,False,True,False]
        elif ptype == 'left': self.ptest = [False,False,False,True]
        else: self.ptest = [False,False,False,False]
        self.push = ptype
    def colrect(self,x,y): return self.rect.move(x,y) #doesn't alter self.rect, so faster copy
    def colrectu(self,x,y): #updates fake vars (useful for now)
        rect = self.rect.move(x,y)
        (self.posx,self.posy,self.oldposx,self.oldposy,self.xw,self.yw) = (rect.centerx,rect.centery,rect.centerx,rect.centery,rect.w/2,rect.h/2)
        return rect
    def hit(self,px,py,dx,dy): #resolve for characters (when created)
        (px,py,ox,oy) = (self.posx,self.posy,self.oldposx,self.oldposy)
        (vx,vy) = (px-ox,py-oy) #velocity
        dp = (vx*dx+vy*dy)
        (nx,ny) = (dp*dx,dp*dy) #normal velocity
        (tx,ty) = (vx-nx,vy-ny) #tangent velocity
        (fx,fy,bx,by) = (0,0,0,0) #collision reponse forces
        if dp < 0: (fx,fy,bx,by) = (tx*self.friction,ty*self.friction,nx*(self.bounce+1),ny*(self.bounce+1)) #apply if entering collision
        self.posx += px
        self.posy += py
        self.oldposx += px + fx + bx
        self.oldposy += py + fy + by
class silenTile:
    CONST45 = 1/math.sqrt(2)
    CONST22 = 1/math.sqrt(5)
    def __init__(self,tilenum,mx,my,xhw,yhw): #create block of type tilenum
        (self.posx,self.posy) = (16+32*mx,16+32*my)
        (self.xw,self.yw) = (xhw,yhw)
        (self.minx,self.maxx,self.miny,self.maxy) = (self.posx-xhw,self.posx+xhw,self.posy-yhw,self.posy+yhw)
        (self.signx,self.signy,self.sx,self.sy) = (0,0,0,0)
        self.settile(tilenum)
    def settile(self,tilenum): #optimizable
        if tilenum == 4 or tilenum == 5:
            print "Some idiot used the \"do not use\" tiles in the editor..."
            raise SystemExit()
        self.id = tilenum
        #ctypes are:{0:empty,1:full,2:45deg,3:22degs,4:22degB,5:67degs,6:67degB,7:corner,8:half}
        if tilenum == 1: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (1,0,0,0,0) #full
        elif tilenum == 2: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (2,-1,-1,self.__class__.CONST45,self.__class__.CONST45) #45nn
        elif tilenum == 3: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (2,1,-1,self.__class__.CONST45,self.__class__.CONST45) #45pn
        elif tilenum == 6: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (2,-1,1,self.__class__.CONST45,self.__class__.CONST45) #45np
        elif tilenum == 7: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (2,1,1,self.__class__.CONST45,self.__class__.CONST45) #45pp
        elif tilenum == 8: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (3,-1,-1,-self.__class__.CONST22,-2*self.__class__.CONST22) #22.5snn
        elif tilenum == 9: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (4,-1,-1,-self.__class__.CONST22,-2*self.__class__.CONST22) #22.5Bnn
        elif tilenum == 10: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (5,-1,-1,-2*self.__class__.CONST22,-self.__class__.CONST22) #67.5snn
        elif tilenum == 11: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (6,-1,-1,-2*self.__class__.CONST22,-self.__class__.CONST22) #67.5Bnn
        elif tilenum == 12: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (3,1,-1,self.__class__.CONST22,-2*self.__class__.CONST22) #22.5spn
        elif tilenum == 13: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (4,1,-1,self.__class__.CONST22,-2*self.__class__.CONST22) #22.5Bpn
        elif tilenum == 14: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (5,1,-1,2*self.__class__.CONST22,-self.__class__.CONST22) #67.5spn
        elif tilenum == 15: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (6,1,-1,2*self.__class__.CONST22,-self.__class__.CONST22) #67.5Bpn
        elif tilenum == 16: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (3,-1,1,-self.__class__.CONST22,2*self.__class__.CONST22) #22.5snp
        elif tilenum == 17: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (4,-1,1,-self.__class__.CONST22,2*self.__class__.CONST22) #22.5Bnp
        elif tilenum == 18: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (5,-1,1,-2*self.__class__.CONST22,self.__class__.CONST22) #67.5snp
        elif tilenum == 19: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (6,-1,1,-2*self.__class__.CONST22,self.__class__.CONST22) #67.5Bnp
        elif tilenum == 20: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (3,1,1,self.__class__.CONST22,2*self.__class__.CONST22) #22.5spp
        elif tilenum == 21: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (4,1,1,self.__class__.CONST22,2*self.__class__.CONST22) #22.5Bpp
        elif tilenum == 22: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (5,1,1,2*self.__class__.CONST22,self.__class__.CONST22) #67.5spp
        elif tilenum == 23: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (6,1,1,2*self.__class__.CONST22,self.__class__.CONST22) #67.5Bpp
        elif tilenum == 24: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (7,0,0,0,0) #cornerBR
        elif tilenum == 25: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (7,0,0,0,0) #cornerBL
        elif tilenum == 26: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (8,-1,0,-1,0) #halfR
        elif tilenum == 27: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (8,0,-1,0,-1) #halfD
        elif tilenum == 28: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (7,0,0,0,0) #cornerBR
        elif tilenum == 29: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (7,0,0,0,0) #cornerBL
        elif tilenum == 30: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (8,0,1,0,1) #halfU
        elif tilenum == 31: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (8,1,0,1,0) #halfL
        else: (self.ctype,self.signx,self.signy,self.sx,self.sy) = (0,0,0,0,0) #empty or invalid
    def collide(self,cr,x,y):
        r=cr.colrectu(x,y)
        (posx,posy,xw,yw)=(cr.posx,cr.posy,cr.xw,cr.yw)
        (tx,ty,txw,tyw)=(self.posx,self.posy,self.xw,self.yw)
        dx = posx-tx
        px = txw+xw-abs(dx)
        if 0 < px:
            dy = posy-ty
            py = tyw+yw-abs(dy)
            if 0 < py: #possible collision (intersects bounding box)
                if px < py:
                    py = 0 #horizontal projection
                    if dx < 0: px*=-1 #project to the left if dx < 0, else project right
                else:
                    px = 0 #vertical projection
                    if dy < 0: py*=-1 #project up if dy < 0, else project down
                getattr(self,"col%d" % (self.ctype),"col1")(px,py,cr) #False=no collision,True=collide w/ axis,2=collide w/ special
    def col1(self,x,y,cr): #full
        l = math.hypot(x,y)
        cr.hit(x,y,x/l,y/l)
        return True
    def col2(self,x,y,cr): #45deg
        (signx,signy) = (self.signx,self.signy)
        (ox,oy) = (cr.posx - signx*cr.xw - self.posx,cr.posy - signy*cr.yw - self.posy) #find innermost point of cr
        (sx,sy) = (self.sx,self.sy)
        dp = ox*sx + oy*sy #project on axis
        if dp < 0: #collision
            (sx,sy) = (-dp*sx,-dp*sy) #sx,sy is projection vector
            (nlen,plen) = (math.hypot(sx,sy),math.hypot(x,y))
            if plen < nlen:
                cr.hit(x,y,x/plen,y/plen)
                return True
            cr.hit(sx,sy,self.signx,self.signy)
            return 2
        return False
    def col3(self,x,y,cr): #22degs
        (signx,signy) = (self.signx,self.signy)
        py = cr.posy - signy*cr.yw
        peny = self.posy - py #vector from innermost point on cr to highest point on tile
        if 0 < peny*signy:
            (ox,oy) = (cr.posx-signx*cr.xw-(self.posx+self.xw*signx),cr.posy-signy*cr.yw-(self.posy-self.yw*signy)) #find innermost point of cr, relative to slope
            (sx,sy) = (self.sx,self.sy)
            dp = ox*sx + oy*sy
            if dp < 0: #collision
                (sx,sy) = (-dp*sx,-dp*sy) #sx,sy is projection vector
                (nlen,plen,ay) = (math.hypot(sx,sy),math.hypot(x,y),abs(peny))
                if plen < nlen:
                    if ay < plen:
                        cr.hit(0,peny,0,peny/ay)
                        return 2
                    cr.hit(x,y,x/plen,y/plen)
                    return True
                else:
                    if ay < nlen:
                        cr.hit(0,peny,0,peny/ay)
                        return 2
                    cr.hit(sx,sy,self.sx,self.sy)
                    return 2
        return False
    def col4(self,x,y,cr): #22degB
        (signx,signy,sx,sy) = (self.signx,self.signy,self.sx,self.sy)
        (ox,oy) = (cr.posx-signx*cr.xw-(self.posx-self.xw*signx),cr.posy-signy*cr.yw-(self.posy+self.yw*signy)) #find innermost point of cr, relative to slope
        dp = ox*sx + oy*sy
        if dp < 0: #collision
            (sx,sy) = (-dp*sx,-dp*sy) #sx,sy is projection vector
            (nlen,plen) = (math.hypot(sx,sy),math.hypot(x,y))
            if plen < nlen:
                cr.hit(x,y,x/plen,y/plen)
                return True
            cr.hit(sx,sy,self.sx,self.sy)
            return 2
        return False
    def col5(self,x,y,cr): #67degs
        (signx,signy) = (self.signx,self.signy)
        px = cr.posx - cr.xw*signx
        penx = self.posx - px
        if 0 < penx*signx:
            (ox,oy) = (cr.posx-signx*cr.xw-(self.posx-self.xw*signx),cr.posy-signy*cr.yw-(self.posy+self.yw*signy)) #find innermost point of cr, relative to slope
            (sx,sy) = (self.sx,self.sy)
            dp = ox*sx + oy*sy
            if dp < 0: #collision
                (sx,sy) = (-dp*sx,-dp*sy) #sx,sy is projection vector
                (nlen,plen,ax) = (math.hypot(sx,sy),math.hypot(x,y),abs(penx))
                if plen < nlen:
                    if ax < plen:
                        cr.hit(penx,0,penx/ax,0)
                        return 2
                    cr.hit(x,y,x/plen,y/plen)
                    return True
                else:
                    if ax < nlen:
                        cr.hit(penx,0,penx/ax,0)
                        return 2
                    cr.hit(sx,sy,self.sx,self.sy)
                    return 2
        return False
    def col6(self,x,y,cr): #67degB
        (signx,signy,sx,sy) = (self.signx,self.signy,self.sx,self.sy)
        (ox,oy) = (cr.posx-signx*cr.xw-(self.posx+self.xw*signx),cr.posy-signy*cr.yw-(self.posy-self.yw*signy)) #find innermost point of cr, relative to slope
        dp = ox*sx + oy*sy
        if dp < 0: #collision
            (sx,sy) = (-dp*sx,-dp*sy) #sx,sy is projection vector
            (nlen,plen) = (math.hypot(sx,sy),math.hypot(x,y))
            if plen < nlen:
                cr.hit(x,y,x/plen,y/plen)
                return True
            cr.hit(sx,sy,self.sx,self.sy)
            return 2
        return False
    def col8(self,x,y,cr): #half (same as col2)
        (sx,sy) = (self.signx,self.signy) #(sx,sy) axis vector is equivalent to (signx,signy) when horiz/vert
        (ox,oy) = (cr.posx - sx*cr.xw - self.posx,cr.posy - sy*cr.yw - self.posy) #find innermost point of cr
        dp = ox*sx + oy*sy #project on axis
        if dp < 0: #collision
            (sx,sy) = (-dp*sx,-dp*sy) #sx,sy is projection vector
            (nlen,plen) = (math.hypot(sx,sy),math.hypot(x,y))
            if plen < nlen:
                cr.hit(x,y,x/plen,y/plen)
                return True
            cr.hit(sx,sy,self.signx,self.signy)
            return 2
        return False
class silenMap:
    def __init__(self,fname,playerref):
        #self.clock = pygame.time.Clock()
        try:
            fileobj = open(fname,"rb")
            try:
                fin = array.array('B')
                fin.fromfile(fileobj,5)
                (self.width,self.height,self.mapid,self.layers,self.ppos)=(fin[0],fin[1],fin[2],fin[3],fin[4])
                self.coldata = [] #coldata[layer][width][height]
                for lyr in range(self.layers):
                    fin = array.array('B')
                    fin.fromfile(fileobj,self.width*self.height)
                    self.coldata.append(numpy.array(fin.tolist(),numpy.int_).reshape(self.width,self.height))
                (self.camx,self.camy) = (0,0)
                self.mappic = load_image("map%02d.png" % (self.mapid))
                self.pref = playerref
            finally: fileobj.close()
        except IOError:
            print "Couldn't open \"%s\"." % (fname)
            raise SystemExit()
    def update(self): pass
    def draw(self): pass
    def collide(self,x,y,crlist): #returns list of all colliding contact regions, and push-out amounts
        (mapx,mapy) = (x//32,y//32)
        maptype = self.coldata[0][mapx][mapy]
        #rectlist = [cr.colrect(x,y) for cr in crlist]
        f = getattr(self,"colblock%02d" % (maptype),"colblock00")
        rtn = [f(mapx,mapy,cr.colrect(x,y),cr) for cr in crlist]
        #rtn = []
        #for rect in rectlist:
        #    rtn.append(f(xpos,ypos,rect))
    def projrect(self,r,ax,ay): #project a rect onto an axis, return "halfwidth" on axis
        return abs(ax*r.w/2)+abs(ay*r.h/2)
    def colblock00(self,mx,my,r,cr): return False #empty block
    def colblock01(self,mx,my,r,cr): #full block
        mr = Rect(32*mx,32*my,32,32)
        (deltax,deltay) = (mr.w-r.w,mr.h-r.h)
        (px,py) = (r.centerx-mr.centerx
        if maprect.colliderect(r): pass
            
            
"""
class silenMap:
    def __init__(self,fname,ifname):
        self.data = array.array('B')
        try:
            fd = open(os.path.join("data",fname),"rb")
            width = fd.read(1)
            height = fd.read(1)
            self.data.fromfile(fd,width*height)
        finally: fd.close()
if __name__ == '__main__':# main()
    nar = numpy.arange(1,5)
    print nar
    testfile = open(os.path.join("mapdata","test.map"),"wb")
    #testfile.write('%x' % (1))
    out = array.array('B')
    out.fromlist([elem for elem in nar.flat])
    print out
    out.tofile(testfile)
    testfile.close()
    additdata = array.array('B')
    try:
        fd = open(os.path.join("mapdata","test.map"),"rb")
        additdata.fromfile(fd,2)
        print additdata[0], additdata[1]
    finally: fd.close()
    raise SystemExit()
    pygame.init()
    pygame.display.set_caption('silen v0.1')
    pygame.mouse.set_visible(0)
    size = width, height =  640, 480
    screen = pygame.display.set_mode(size) # create here so events work
    event = silenEvent()
    while(1):
        event.update()
        if event.fsflag:
            event.fsflag = False
            if fstoggle: screen = pygame.display.set_mode(size)
            else: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            fstoggle = not fstoggle
"""
"""
for event in pygame.event.get():
    if event.type == pygame.KEYDOWN:
        print event.key
        if event.key == pygame.K_ESCAPE: raise SystemExit()
"""

"""
class Creator:
    def __init__(self):
        self.dirt_img, self.dirt_img_rect = load_image("dirt.png")
        self.turret_img, self.turret_img_rect = load_image("flamethrower.png")
        self.turret_img_r, self.turret_img_rect_r = load_image("flamethrower_r.png")
        self.wall_img, self.wall_img_rect = load_image("brick.png")
        self.goal_img, self.goal_img_rect = load_image("target.png")
        self.grass_img, self.grass_img_rect = load_image("grass.png")
    def __call__(self, value):
        if value == "1": return GrassBlock(self.grass_img)
        elif value == "2": return WallBlock(self.wall_img)
        elif value == "3": return DirtBlock(self.dirt_img)
        elif value == "5": return TurretBlock(self.turret_img,1)
        elif value == "6": return TurretBlock(self.turret_img_r,-1)
        elif value == "7": return GoalBlock(self.goal_img)
        elif int(value) >= 10: return TrapBlock(self.dirt_img,self.wall_img,int(value))
        else: return EmptyBlock() #value == "0" or invalid
create_block = Creator()
class Grid:
    def __init__(self, file_name):
        self.valid = True
        self.move_counter = 0
        self.move_digtime = 0
        self.move_x = 0
        self.move_y = 0
        self.move_direction = -1
        self.still_alive = True
        self.win = False
        self.timer = -1
        self.real_x = 0
        self.real_y = 0
        self.width = 20
        self.height = 15
        self.settimer = 900
        self.rows = []
        # intitialize map
        try: fd = open(os.path.join("data",file_name))
        except IOError:
            self.valid = False
            return
        regread = re.compile(r"\d+") # any number of numeric characters (greedy)
        line = fd.readline()
        data = regread.findall(line) # ignore any amount of whitespace and text in first line
        if len(data) < 2: # first line should have width, height, and (possibly) timer frames
            self.valid = False
            return
        self.width = int(data[0])
        self.height = int(data[1])
        if len(data) >= 3: self.settimer = int(data[2])
        data = []
        for i in range(self.height):
            line = fd.readline()
            data = regread.findall(line) # ignore any amount of whitespace and text in file
            if len(data) < self.width: # if there aren't enough numbers in the line, quit
                self.valid = False
                return
            row = [create_block(data[j]) for j in range(self.width)]
            self.rows.append(row)
    def draw(self, screen):
        y = 240 - self.real_y
        ypos = 0
        for row in self.rows:
            x = 320 - self.real_x
            xpos = 0
            for block in row:
                block.draw(screen, x, y)
                if block.is_active() and block.get_facing() == -1:
                    if ypos == int((self.real_y+16)/32) and  xpos - 3 <= int((self.real_x+16)/32) and int((self.real_x+16)/32) <= xpos:
                        self.still_alive = False
                        return
                if block.is_active() and block.get_facing() == 1:
                    if ypos == int((self.real_y+16)/32) and  xpos <= int((self.real_x+16)/32) and int((self.real_x+16)/32) <= xpos + 3:
                        self.still_alive = False
                        return
                xpos += 1
                x += 32
            ypos += 1
            y += 32
        draw_shroud(screen)
        row = self.rows[0]
        y = 240 - self.real_y
        x = 320 - self.real_x
        for block in row:
            block.draw(screen, x, y)
            x += 32
        if self.timer != -1:
            my_font = pygame.font.Font('data/quartzitalic.ttf',64)
            if (self.timer%30)*2 < 10: screen.blit(my_font.render('%i:0%i' % (self.timer/30, (self.timer%30)*2),True,(0,255,0)),(0,0))
            else: screen.blit(my_font.render('%i:%i' % (self.timer/30, (self.timer%30)*2),True,(0,255,0)),(0,0))
    def update(self):
        if self.timer != -1:
            if self.real_y == 0:
                self.win = True
                return
            elif self.timer == 0:
                self.still_alive = False
                return
            else: self.timer -= 1
        elif self.rows[int(self.real_y/32)][int(self.real_x/32)].is_goal() and self.timer == -1: self.timer = self.settimer
        if self.move_digtime > 1: self.move_digtime -=1
        elif self.move_digtime == 1: # kill block
            self.move_digtime = 0
            if self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)].is_trap():
                for row in self.rows:
                    for curblock in row:
                        if curblock.is_trap() and self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)].trapnum == curblock.trapnum:
                            curblock.triggered = True
            elif self.real_y+self.move_y*4 == 0: self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)] = create_block("1")
            else: self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)] = EmptyBlock()
        elif self.move_counter > 0: # fluid movement
            #(add_x,add_y) = (int(self.move_x/self.move_counter),int(self.move_y/self.move_counter))
            #(self.move_x,self.move_y)=(self.move_x-add_x,self.move_y-add_y)
            (self.real_x,self.real_y)=(self.real_x+self.move_x,self.real_y+self.move_y)
            self.move_counter -=1
        return
    def is_passable(self,x,y): return x >= 0 and x < self.width and y >= 0 and y < self.height and self.rows[y][x].is_passable()
    def is_diggable(self,x,y): return x >= 0 and x < self.width and y >= 0 and y < self.height and self.rows[y][x].is_diggable()
    def move(self,delta_x,delta_y):
        if self.move_counter == 0:
            target_x = int(self.real_x/32) + delta_x
            target_y = int(self.real_y/32) + delta_y
            if self.is_passable(target_x,target_y): (self.move_x,self.move_y,self.move_counter) = (delta_x*8,delta_y*8,4)
            elif self.is_diggable(target_x,target_y): (self.move_x,self.move_y,self.move_counter,self.move_digtime) = (delta_x*8,delta_y*8,4,3)
    def cancel_move(self):
        if(self.move_digtime > 0): (self.move_digtime,self.move_counter) = (0,0)
class Digger:
    def __init__(self):
        self.x = 0
        self.y = 0
        self.img, self.img_rect = load_image("test.png")
        self.grass_img, self.grass_img_rect = load_image("snake_grass.png")
    def draw(self, screen):
        screen.blit(self.img,(320+self.x*32,240+self.y*32))
def lose(screen):
    #print "LOSE"
    lose_img, lose_img_rect = load_image("lose.png")
    screen.blit(lose_img,(0,0))
def win(screen):
    #print "WIN"
    img, img_rect = load_image("win.png")
    screen.blit(img,(0,0))
def intro(screen):
    #print "WIN"
    img, img_rect = load_image("intro.png")
    screen.blit(img,(0,0))
def draw_shroud(screen):
    img, img_rect = load_image("fow.png")
    screen.blit(img,(0,0))
def build_level(level):
    return Grid("Level%s.txt" % level)
class GameManager:
    def __init__(self):
        self.start = False
        self.screen = pygame.display.set_mode(size)
        self.black = 0, 0, 0
        self.fstoggle = False
        self.background, self.background_rect = load_image("black.png")
        self.clock = pygame.time.Clock()
        self.keydown = [False,False,False,False]
        self.timer = 0
        self.score = 0
        self.level = 1
        self.player = Digger()
        self.move_counter = 0
        self.grid = None
        self.skipintro = False
        self.screen.blit(self.background, (0, 0))
        pygame.display.flip()
        pygame.mixer.init()
        pygame.mixer.music.load('data/UndergroundMix.mp3')
        pygame.mixer.music.play(-1)
    def common_events(self,event):
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F1:
                if self.fstoggle: self.screen = pygame.display.set_mode(size)
                else: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                self.fstoggle = not self.fstoggle
                return True
        return False
    def loop(self):
        while not self.start and not self.skipintro:
            intro(self.screen)
            pygame.display.flip()
            self.clock.tick(30)
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_c: self.start = True # continue
                    else: (self.level,self.start) = (1,True) # restart
        self.skipintro = False
        self.grid = build_level(self.level)
        if not self.grid.valid: raise SystemExit() # finished the available levels
        while self.grid.still_alive and not self.grid.win:
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key >= 273 and event.key <= 276: self.keydown[event.key-273] = True # arrow keys
                elif event.type == pygame.KEYUP:
                    if event.key >= 273 and event.key <= 276:
                        self.keydown[event.key-273] = False # arrow keys
                        self.grid.cancel_move()
            if self.keydown[0]: self.grid.move(0,-1)
            elif self.keydown[1]: self.grid.move(0,1)
            elif self.keydown[2]: self.grid.move(1,0)
            elif self.keydown[3]: self.grid.move(-1,0)
            self.clock.tick(30)
            self.screen.blit(self.background, (0,0))
            self.grid.update()
            self.grid.draw(self.screen)
            self.player.draw(self.screen)
            pygame.display.flip()
        self.keydown = [False,False,False,False] # incase player was holding down a key when they died
        self.start = False
        while not self.start:
            self.clock.tick(30)
            if self.grid.win: win(self.screen)
            else: lose(self.screen)
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_c: (self.start,self.skipintro) = (True,True) # continue
                    else: self.start = True
            pygame.display.flip()
        if self.grid.win: self.level += 1
        else: self.start = False
"""
