# silen v0.1
import pygame, sys, os, re
from pygame.locals import *
from random import *
from event import *
from sprite import *

pygame.init()
pygame.display.set_caption('CrossShift+')
pygame.mouse.set_visible(0)
size = width, height =  640, 480
screen = pygame.display.set_mode(size) # create here so Creator class has a video mode to work with
"""
# screen constants & pygame initialization
def load_image(name, colorkey=None):
    fullname = os.path.join('data', name)
    try: image = pygame.image.load(fullname)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    image = image.convert_alpha()
    return image, image.get_rect()
def main():
    game = GameManager()
    while(1): game.loop()
"""
"""
def load_image(name,colorkey=None): #colorkey={None - convert alpha, (R,G,B[,A]) - set colorkey, 0 - do neither)
    fullname = os.path.join('data', name)
    try: image = pygame.image.load(fullname)#name)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    if colorkey == None: image = image.convert_alpha()
    else:
        image = image.convert()
        if colorkey != 0: image.set_colorkey(colorkey)
    return image#, image.get_rect()
"""
def new_cboard():
    board = []
    for i in range(8):
        row = []
        for j in range(8): row.append(False)
        board.append(row)
    return board
class CroshiftPiece(silenSprite):
    classtimes = [10,10,10,10,10,10,10,10]
    classdata = load_image('pieces.png',None)
    classrect = classdata.get_rect()
    def __init__(self,value,jstart=0,istart=0,specialcase=False):
        self.alldata = self.__class__.classdata
        self.allrect = self.alldata.get_rect()
        if specialcase:
            self.cx = silenVar(546) # 54 wide, 18 start offset, 27 to get to center
            self.cy = silenVar(150)
        else:
            self.cx = silenVar(225) # 54 wide, 18 start offset, 27 to get to center
            self.cy = silenVar(225)
        self.xscale = silenVar(1.0) #these vars are proportions only, unfortunately
        self.yscale = silenVar(1.0)
        self.rot = silenVar(0.0)
        self.alpha = silenVar(255) #only works with colorkey pictures
        (self.rfill,self.gfill,self.bfill,self.afill) = (silenVar(0),silenVar(0),silenVar(0),silenVar(0)) #afill only works on surfaces w/ alpha
        self.fill = lambda: (self.rfill(),self.gfill(),self.bfill(),self.afill())
        self.svlist = [self.cx,self.cy,self.xscale,self.yscale,self.rot,self.alpha,self.rfill,self.gfill,self.bfill,self.afill]
        self.oldxscale = 1.0
        self.oldyscale = 1.0
        self.oldrot = 0.0
        self.oldalpha = 255
        (self.oldrfill,self.oldgfill,self.oldbfill,self.oldafill) = self.oldfill = (0,0,0,0) #same ref, meaning changing one will affect the other (as it should)
        self.data = None
        self.rect = None
        self.pdelay = silenPicDelay(self.__class__.classtimes,self.__class__.classrect,4,2,True,4*value) #setup for animation / correct frame drawing
        self.pdelay.active = False #keep the current frame locked until capture, when animation occurs
        self.oldpdelay = self.pdelay()
        self.value = value #value is 0 for black pieces and 1 for white pieces
        self.changepic(True)
        (self.i,self.j) = (istart,jstart)
        if not specialcase: self.moveposa(istart*54 + 45,jstart*54 + 45,30,3,8*jstart+istart)
    def bounce(self,amt,time,delay=0.0,tie=None,minix=0,startix=0,startdir=1):
        return self.cy.add(time,-amt,2,True,False,delay,tie,minix,startix,startdir)
    def shifth(self,row,amti): #amti is a number from -8 to +8
        if row != self.j or (amti+8)%8 == 0: return #make sure this piece belongs to the moving row, and that the row is moving
        newi = (self.i + 8 + amti)%8 #the new i position
        print "(%d," % self.i,"%d)" % self.j,newi
        if amti < 0: #move pieces left
            if newi > self.i: #hit an edge
                if self.i != 0: toend = self.moveposa(45,self.cy.final(),5*self.i+1,0) #move from old to end
                else: toend = None
                offend = self.moveposa(-9,self.cy.final(),3,0,0.0,toend) #move off end
                jump = self.moveposa(477,self.cy.final(),1,0,0.0,offend) #pop to other end (1 frame)
                onend = self.moveposa(423,self.cy.final(),3,0,1.0,jump) #move on new end
                if newi != 7: self.moveposa(54*newi+45,self.cy.final(),5*(7-newi),0,0.0,onend) #move from new end to new pos
            else: self.moveposa(54*newi+45,self.cy.final(),5*(self.i-newi),0) #didn't hit an edge
        else: #move pieces right
            if newi < self.i: #hit an edge
                if self.i != 7: toend = self.moveposa(423,self.cy.final(),5*(7-self.i)+1,0) #move from old to end
                else: toend = None
                offend = self.moveposa(477,self.cy.final(),3,0,0.0,toend) #move off end
                jump = self.moveposa(-9,self.cy.final(),1,0,0.0,offend) #pop to other end (1 frame)
                onend = self.moveposa(45,self.cy.final(),3,0,1.0,jump) #move on new end
                if newi != 0: self.moveposa(54*newi+45,self.cy.final(),5*newi,0,0.0,onend) #move from new end to new pos
            else: self.moveposa(54*newi+45,self.cy.final(),5*(newi-self.i),0) #didn't hit an edge
        self.i = newi
    def shiftv(self,col,amtj): #amtj is a number from -8 to +8
        if col != self.i or (amtj+8)%8 == 0: return #make sure this piece belongs to the moving col, and that the col is moving
        newj = (self.j + 8 + amtj)%8 #the new j position
        if amtj < 0: #move pieces up
            if newj > self.j: #hit an edge
                if self.j != 0: toend = self.moveposa(self.cx.final(),45,5*self.j+1,0) #move from old to end
                else: toend = None
                offend = self.moveposa(self.cx.final(),-9,3,0,0.0,toend) #move off end
                jump = self.moveposa(self.cx.final(),477,1,0,0.0,offend) #pop to other end (1 frame)
                onend = self.moveposa(self.cx.final(),423,3,0,1.0,jump) #move on new end
                if newj != 7: self.moveposa(self.cx.final(),54*newj+45,5*(7-newj),0,0.0,onend) #move from new end to new pos
            else: self.moveposa(self.cx.final(),54*newj+45,5*(self.j-newj),0) #didn't hit an edge
        else: #move pieces down
            if newj < self.j: #hit an edge
                if self.j != 7: toend = self.moveposa(self.cx.final(),423,5*(7-self.j)+1,0) #move from old to end
                else: toend = None
                offend = self.moveposa(self.cx.final(),477,3,0,0.0,toend) #move off end
                jump = self.moveposa(self.cx.final(),-9,1,0,0.0,offend) #pop to other end (1 frame)
                onend = self.moveposa(self.cx.final(),45,3,0,1.0,jump) #move on new end
                if newj != 0: self.moveposa(self.cx.final(),54*newj+45,5*newj,0,0.0,onend) #move from new end to new pos
            else: self.moveposa(self.cx.final(),54*newj+45,5*(newj-self.j),0) #didn't hit an edge
        self.j = newj
    def capture(self,newbd): #animate the piece when captured, and update self.value
        if self.value == newbd[self.j][self.i]: return
        self.pdelay.active = True #start animation
        self.value = 1-self.value #change value of piece
        self.pdelay.endix = 4*self.value #stop at the new piece's frame
        self.bounce(10,20) #bounce effect, so the piece spins in midair
    def flip(self): #for the current player piece (special case, no check capture)
        self.pdelay.active = True #start animation
        self.value = 1-self.value #change value of piece
        self.pdelay.endix = 4*self.value #stop at the new piece's frame
        self.bounce(10,20) #bounce effect, so the piece spins in midair
class CroshiftEngine:
    def __init__(self,screen,event,fsflag,force=True):
        self.piclist = [silenSprite('board.png',0,225,225,0),silenSprite(None,(0,0,255,0),234,261,255,(432,54)),silenSprite(None,(0,0,255,0),261,234,255,(54,432)),
                        silenSprite('dice.png',0,505,54,0),silenSprite('dice.png',0,586,54,0),CroshiftPiece(0,9,9,True)]
        self.piclist[0].fadein(30)
        self.piclist[3].makeanim([1,1,1,1],4,1)
        self.piclist[3].pdelay.active = False
        self.piclist[4].makeanim([1,1,1,1],4,1)
        self.piclist[4].pdelay.active = False
        self.clock = pygame.time.Clock()
        self.screen = screen
        self.event = event
        self.fsflag = fsflag #if currently fullscreen or not
        self.force = force #forced dice rolls (True by default)
        self.pieces = []
        self.valid = [True,True,True,True,True,True,True,True]
        (self.posx,self.posy) = (0,4)
        #taken from c++ version
        self.oldbd = None #for undo
        self.board = new_cboard()
        self.newbd = new_cboard()
        self.cap = False
        #self.temp = new_cboard()
        self.work = []
        self.curplayer = 0
        (self.dicea, self.diceb) = (None,None)
        self.reset()
    def reset(self): #set the initial state of the board
        self.pieces = []
        for i in range(8):
            for j in range(4):
                (self.board[i][j],self.board[i][j+4]) = (0,1)
                self.pieces.append(CroshiftPiece(0,i,j))
                self.pieces.append(CroshiftPiece(1,i,j+4))
    def rolldice(self): (self.dicea,self.diceb) = (randint(0,5)%4+1,randint(0,5)%4+1) #roll the dice. fives become 1's, and sixes become 2's
    def printbd(self,board):
        print '+_a_b_c_d_e_f_g_h_'
        for i in range(8): print "%c" % (65+i) + "".join(["|%d" % (board[i][j]) for j in range(8)]) + "|"
    def run(self): #called once at the start of the game, loops itself until game is over.
        self.event.reset()
        (runflag,runpos,wait,validmove,oldvalidmove,oldcap) = (True,0,0,None,None,False)
        while runflag:
            self.event.update()
            if self.event.fsflag:
                (self.event.fsflag,self.fsflag) = (False,not self.fsflag)
                if self.fsflag: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                else: self.screen = pygame.display.set_mode(size)
            if wait <= 0:
                if runpos == 0: #initialize row turn
                    if self.force:
                        self.rolldice()
                        self.valid = [True,False,False,False,False,False,False,False] #moving zero is always allowed
                        (self.valid[self.dicea],self.valid[-self.dicea]) = (True,True) #these positions are shiftable to
                        (self.valid[self.diceb],self.valid[-self.diceb]) = (True,True) #these positions are shiftable to
                        (self.piclist[3].pdelay.ix,self.piclist[4].pdelay.ix) = (self.dicea-1,self.diceb-1)
                        self.piclist[3].rotate(360,30,2,30)
                        self.piclist[3].fadein(30,30)
                        self.piclist[4].rotate(360,30,2,60)
                        self.piclist[4].fadein(30,60)
                        print self.valid
                    (self.posx,self.posy) = (0,4)
                    self.piclist[1].setposa(234,self.posy*54+45)
                    self.piclist[1].finishfill()
                    self.piclist[1].tweenfill((0,0,255,None),1)
                    self.piclist[1].tweenfill((None,None,None,128),45,0,0.0, self.piclist[1].tweenfill((None,None,None,64),30,0,64.0) ,True,True)
                    runpos += 1
                    wait = 94
                elif runpos == 1: #select row with up/down, shift to next valid with left/right (maintain location)
                    if self.event.getkeys([pygame.K_RETURN, pygame.K_z, pygame.K_SPACE]): #finalize row turn, disable one die, initialize col turn
                        if validmove: #otherwise, do nothing (it's suicide)
                            if self.cap: self.capturepieces()
                            wait = self.cap and 40 or 5
                            (self.cap,runpos,validmove,oldvalidmove,oldcap) = (False,2,None,None,False)
                            self.piclist[1].finishfill() #kills animated fill correctly
                            self.piclist[1].tweenfill((None,None,None,0),5)
                            self.oldbd = self.board
                            self.board = self.newbd
                            self.newbd = new_cboard()
                            if self.force:
                                self.valid = [True,False,False,False,False,False,False,False]
                                if self.posx == self.dicea or self.posx == 8-self.dicea:
                                    (self.valid[self.diceb],self.valid[-self.diceb]) = (True,True)
                                    self.piclist[3].fadeout(30)
                                else:
                                    (self.valid[self.dicea],self.valid[-self.dicea]) = (True,True)
                                    self.piclist[4].fadeout(30)
                                print self.valid
                            (self.posx,self.posy) = (4,0)
                            self.piclist[2].setposa(self.posx*54+45,234)
                            self.piclist[2].finishfill() #kills animated fill correctly
                            self.piclist[2].tweenfill((0,0,255,None),1)
                            self.piclist[2].tweenfill((None,None,None,128),45,0,0.0, self.piclist[2].tweenfill((None,None,None,64),5,0,wait-5) ,True,True)
                    elif self.event.getkey(pygame.K_UP):
                        amt = (self.posx < 8-self.posx) and -self.posx or 8-self.posx
                        for piece in self.pieces: piece.shifth(self.posy,amt) #reset pieces in the row
                        wait = max(5,5*min(self.posx,8-self.posx)) #5*abs(amt)
                        (self.posx,self.posy,validmove) = (0,(self.posy+7)%8,None)
                        self.piclist[1].moveposa(234,self.posy*54 + 45,5,2)
                    elif self.event.getkey(pygame.K_DOWN):
                        amt = (self.posx < 8-self.posx) and -self.posx or 8-self.posx
                        for piece in self.pieces: piece.shifth(self.posy,amt) #reset pieces in the row
                        wait = max(5,5*min(self.posx,8-self.posx))
                        (self.posx,self.posy,validmove) = (0,(self.posy+1)%8,None)
                        self.piclist[1].moveposa(234,self.posy*54 + 45,5,2)
                    elif self.event.getkey(pygame.K_LEFT):
                        value = -1
                        while value != -8 and not self.valid[(self.posx+value+8)%8]: value -= 1
                        for piece in self.pieces: piece.shifth(self.posy,value) #move the pieces in the row
                        self.posx = (self.posx+value+8)%8
                        validmove = self.shifth(self.posy,self.posx)
                        if self.posx == 0: validmove = None
                        wait = -5*value
                    elif self.event.getkey(pygame.K_RIGHT):
                        value = 1
                        while value != 8 and not self.valid[(self.posx+value)%8]: value += 1
                        for piece in self.pieces: piece.shifth(self.posy,value) #move the pieces in the row
                        self.posx = (self.posx+value+8)%8
                        validmove = self.shifth(self.posy,self.posx)
                        if self.posx == 0: validmove = None
                        wait = 5*value
                    if validmove != oldvalidmove or oldcap != self.cap:
                        oldvalidmove = validmove; oldcap = self.cap
                        if validmove == None: self.piclist[1].tweenfill((0,0,255,None),wait)
                        if validmove == True:
                            if self.cap: self.piclist[1].tweenfill((255,255,0,None),wait)
                            else: self.piclist[1].tweenfill((0,255,0,None),wait)
                        if validmove == False: self.piclist[1].tweenfill((255,0,0,None),wait)
                elif runpos == 2:
                    if self.event.getkeys([pygame.K_BACKSPACE, pygame.K_x]): #undo (reset row turn, board, 'capture' to old board)
                        (self.cap,runpos,validmove,oldvalidmove,oldcap) = (False,1,None,None,False)
                        self.piclist[2].finishfill() #kills animated fill correctly
                        self.piclist[2].tweenfill((None,None,None,0),5)
                        (self.posx,self.posy) = (0,4)
                        self.piclist[1].setposa(234,self.posy*54+45)
                        self.piclist[1].finishfill()
                        self.piclist[1].tweenfill((0,0,255,None),1)
                        self.piclist[1].tweenfill((None,None,None,128),45,0,0.0, self.piclist[1].tweenfill((None,None,None,64),5,0,25.0) ,True,True)
                        if self.force:
                            self.valid = [True,False,False,False,False,False,False,False]
                            (self.valid[self.dicea],self.valid[-self.dicea]) = (True,True)
                            (self.valid[self.diceb],self.valid[-self.diceb]) = (True,True)
                            self.piclist[3].fadein(30)
                            self.piclist[4].fadein(30)
                        wait = 30
                        self.newbd = self.board = self.oldbd
                        self.capturepieces()
                        self.oldbd = None
                        self.newbd = new_cboard()
                    elif self.event.getkeys([pygame.K_RETURN, pygame.K_z, pygame.K_SPACE]): #finalize col turn
                        if validmove: #otherwise, do nothing (it's suicide)
                            if self.cap: self.capturepieces()
                            wait = self.cap and 40 or 5
                            (self.cap,runpos,validmove,oldvalidmove) = (False,3,None,None)
                            self.piclist[2].finishfill() #kills animated fill correctly
                            self.piclist[2].tweenfill((None,None,None,0),5)
                            self.oldbd = None
                            self.board = self.newbd
                            self.newbd = new_cboard()
                            if self.force:
                                self.piclist[3].fadeout(30)
                                self.piclist[4].fadeout(30)
                    elif self.event.getkey(pygame.K_LEFT):
                        amt = (self.posy < 8-self.posy) and -self.posy or 8-self.posy
                        for piece in self.pieces: piece.shiftv(self.posx,amt) #reset pieces in the row
                        wait = max(5,5*min(self.posy,8-self.posy))
                        (self.posx,self.posy,validmove) = ((self.posx+7)%8,0,None)
                        self.piclist[2].moveposa(self.posx*54 + 45,234,5,2)
                    elif self.event.getkey(pygame.K_RIGHT):
                        amt = (self.posy < 8-self.posy) and -self.posy or 8-self.posy
                        for piece in self.pieces: piece.shiftv(self.posx,amt) #reset pieces in the row
                        wait = max(5,5*min(self.posy,8-self.posy))
                        (self.posx,self.posy,validmove) = ((self.posx+1)%8,0,None)
                        self.piclist[2].moveposa(self.posx*54 + 45,234,5,2)
                    elif self.event.getkey(pygame.K_UP):
                        value = -1
                        while value != -8 and not self.valid[(self.posy+value+8)%8]: value -= 1
                        for piece in self.pieces: piece.shiftv(self.posx,value) #move the pieces in the row
                        self.posy = (self.posy+value+8)%8
                        validmove = self.shiftv(self.posx,self.posy)
                        if self.posy == 0: validmove = None
                        self.printbd(self.newbd)
                        wait = -5*value
                    elif self.event.getkey(pygame.K_DOWN):
                        value = 1
                        while value != 8 and not self.valid[(self.posy+value)%8]: value += 1
                        for piece in self.pieces: piece.shiftv(self.posx,value) #move the pieces in the row
                        self.posy = (self.posy+value+8)%8
                        validmove = self.shiftv(self.posx,self.posy)
                        if self.posy == 0: validmove = None
                        self.printbd(self.newbd)
                        wait = 5*value
                    if validmove != oldvalidmove or oldcap != self.cap:
                        oldvalidmove = validmove; oldcap = self.cap
                        if validmove == None: self.piclist[2].tweenfill((0,0,255,None),wait)
                        if validmove == True:
                            if self.cap: self.piclist[2].tweenfill((255,255,0,None),wait)
                            else: self.piclist[2].tweenfill((0,255,0,None),wait)
                        if validmove == False: self.piclist[2].tweenfill((255,0,0,None),wait)
                elif runpos == 3: #check for victory, change curplayer
                    runpos = 0
                    self.curplayer = 1 - self.curplayer
                    if self.victory(): runflag = False
                    if runflag: self.piclist[5].flip()
            else:
                wait -= 1
                self.event.update()
                #self.event.reset()
            self.screen.fill((0,0,0))
            for sprite in self.piclist: #update all background, diceroll, curplayer sprites
                sprite.update()
                self.screen.blit(sprite(),sprite.rect)
            for sprite in self.pieces: #update all pieces
                sprite.update()
                self.screen.blit(sprite(),sprite.rect)
            pygame.display.flip()
            self.clock.tick(30)
    def shifth(self,row,amt): #amounts should be positive, or it won't work.
        for i in range(8):
            for j in range(8): self.newbd[i][j] = self.board[i][j]
        for j in range(8): self.newbd[row][(j+amt)%8] = self.board[row][j]
        self.printbd(self.newbd) #self.draw(self.newbd)
        return self.validmoveh(row)
    def shiftv(self,col,amt): #amounts should be positive, or it won't work.
        for i in range(8):
            for j in range(8): self.newbd[i][j] = self.board[i][j]
        for i in range(8): self.newbd[(i+amt)%8][col] = self.board[i][col]
        self.printbd(self.newbd) #self.draw(self.newbd)
        print "^- first | second -v"
        return self.validmovev(col)
    def searchwork(self,row,col): #search work for position, returns true if not in any.
        for board in self.work:
            if board[row][col]: return False
        return True
    def newwork(self): self.work.append(new_cboard()) #add a new board to the work vector.
    def createblock(self,row,col,searchtype): #recursive block creation at self.work[-1][row][col]
        if self.newbd[row][col] != searchtype: return
        self.work[-1][row][col] = True
        if row-1 >= 0 and not self.work[-1][row-1][col]: self.createblock(row-1,col,searchtype)
        if row+1 < 8 and not self.work[-1][row+1][col]: self.createblock(row+1,col,searchtype)
        if col-1 >= 0 and not self.work[-1][row][col-1]: self.createblock(row,col-1,searchtype)
        if col+1 < 8 and not self.work[-1][row][col+1]: self.createblock(row,col+1,searchtype)
        return
    def lastisunsafe(self): #returns true if self.work[-1] is unsafe
        for i in range(8):
            if self.work[-1][0][i] or self.work[-1][7][i] or self.work[-1][i][0] or self.work[-1][i][7]: return False
        return True
    def capture(self): #captures all True positions at self.work[-1]
        self.cap = True
        for i in range(1,7): #only the middle 6*6 squares can be captured, so don't waste time on the others...
            for j in range(1,7):
                if self.work[-1][i][j]: self.newbd[i][j] = 1-self.newbd[i][j]
    def capturepieces(self): #animates all captured pieces
        self.printbd(self.board)
        self.printbd(self.newbd)
        for piece in self.pieces: piece.capture(self.newbd)
    def validmoveh(self,row): #test each relevant block for safeness, capture unsafe blocks unless self (suicide)
        (self.work,self.cap) = ([],False) #reset workspace for capture tests
        for i in range(1,7): #only need to search the 6*6 center grid for unsafeness
            if self.board[row][i] != self.curplayer and self.newbd[row][i] == self.curplayer: #if piece type changed in shift, block it up
                if row-1 > 0 and self.newbd[row-1][i] != self.curplayer and self.searchwork(row-1,i): #row 0 is automatically safe
                    self.newwork()
                    self.createblock(row-1,i,1-self.curplayer)
                    if self.lastisunsafe(): self.capture()
                if row+1 < 7 and self.newbd[row+1][i] != self.curplayer and self.searchwork(row+1,i): #row 7 is automatically safe
                    self.newwork()
                    self.createblock(row+1,i,1-self.curplayer)
                    if self.lastisunsafe(): self.capture()
            elif self.board[row][i] == self.curplayer and self.newbd[row][i] != self.curplayer: #rows 0 and 7 are automatically safe
                if row%7 != 0 and self.searchwork(row,i):
                    self.newwork()
                    self.createblock(row,i,1-self.curplayer)
                    if self.lastisunsafe(): self.capture()
        self.work = [] #reset workspace for suicide tests (this test is after capture, in case capture removes the suicide threat)
        for i in range(1,7): #only need to search the 6*6 center grid for unsafeness
            if self.board[row][i] == self.curplayer and self.newbd[row][i] != self.curplayer: #if piece type changed in shift, block it up
                if row-1 > 0 and self.newbd[row-1][i] == self.curplayer and self.searchwork(row-1,i): #row 0 is automatically safe
                    self.newwork()
                    self.createblock(row-1,i,self.curplayer)
                    if self.lastisunsafe(): return False
                if row+1 < 7 and self.newbd[row+1][i] == self.curplayer and self.searchwork(row+1,i): #row 7 is automatically safe
                    self.newwork()
                    self.createblock(row+1,i,self.curplayer)
                    if self.lastisunsafe(): return False
            elif self.board[row][i] != self.curplayer and self.newbd[row][i] == self.curplayer: #rows 0 and 7 are automatically safe
                if row%7 != 0 and self.searchwork(row,i):
                    self.newwork()
                    self.createblock(row,i,self.curplayer)
                    if self.lastisunsafe(): return False
        return True
    def validmovev(self,col): #test each relevant block for safeness, capture unsafe blocks unless self (suicide)
        (self.work,self.cap) = ([],False) #reset workspace for capture tests
        for i in range(1,7): #only need to search the 6*6 center grid for unsafeness
            if self.board[i][col] != self.curplayer and self.newbd[i][col] == self.curplayer: #if piece type changed in shift, block it up
                if col-1 > 0 and self.newbd[i][col-1] != self.curplayer and self.searchwork(i,col-1): #col 0 is automatically safe
                    self.newwork()
                    self.createblock(i,col-1,1-self.curplayer)
                    if self.lastisunsafe(): self.capture()
                if col+1 < 7 and self.newbd[i][col+1] != self.curplayer and self.searchwork(i,col+1): #col 7 is automatically safe
                    self.newwork()
                    self.createblock(i,col+1,1-self.curplayer)
                    if self.lastisunsafe(): self.capture()
            elif self.board[i][col] == self.curplayer and self.newbd[i][col] != self.curplayer: #cols 0 and 7 are automatically safe
                if col%7 != 0 and self.searchwork(i,col):
                    self.newwork()
                    self.createblock(i,col,1-self.curplayer)
                    if self.lastisunsafe(): self.capture()
        self.work = [] #reset workspace for suicide tests (this test is after capture, in case capture removes the suicide threat)
        for i in range(1,7): #only need to search the 6*6 center grid for unsafeness
            if self.board[i][col] == self.curplayer and self.newbd[i][col] != self.curplayer: #if piece type changed in shift, block it up
                if col-1 > 0 and self.newbd[i][col-1] == self.curplayer and self.searchwork(i,col-1): #col 0 is automatically safe
                    self.newwork()
                    self.createblock(i,col-1,self.curplayer)
                    if self.lastisunsafe(): return False
                if col+1 < 7 and self.newbd[i][col+1] == self.curplayer and self.searchwork(i,col+1): #col 7 is automatically safe
                    self.newwork()
                    self.createblock(i,col+1,self.curplayer)
                    if self.lastisunsafe(): return False
            elif self.board[i][col] != self.curplayer and self.newbd[i][col] == self.curplayer: #cols 0 and 7 are automatically safe
                if col%7 != 0 and self.searchwork(i,col):
                    self.newwork()
                    self.createblock(i,col,self.curplayer)
                    if self.lastisunsafe(): return False
        return True
    def victory(self): #checks if the current player has a cross at the start of their turn
        (row,col,i) = (False,False,0)
        while i<8 and not (row and col):
            j=0
            while j<8 and self.board[j][i] == self.curplayer: j+=1
            if j >= 8: row = True #found a row
            j=0
            while j<8 and self.board[i][j] == self.curplayer: j+=1
            if j >= 8: col = True #found a col
            i+=1
        return row and col #if both a col and row were found, CROSS! self.curplayer wins!
    def update(self): #called once per frame, to handle input.
        self.event.update()
        if self.event.fsflag:
            (self.event.fsflag,self.fsflag) = (False,not self.fsflag)
            if self.fsflag: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            else: self.screen = pygame.display.set_mode(size)
        
def main():
    event = silenEvent()
    print "started"
    game = CroshiftEngine(screen,event,False,True)
    print "made"
    game.run()
    print "done"
"""
    screen = pygame.display.set_mode(size)
    startscreen = [silenSprite('bluegradient.png',0,320,240),silenSprite('cutscenebars.png',None,320,240),silenSprite('shifttext.png',None,720,240),
                   silenSprite('crosstoppt.png',None,320,90),silenSprite('crossleftpt.png',None,120,240),silenSprite('crossbotpt.png',None,320,400),
                   silenSprite('cross.png',(68,178,142),472,295,0),silenSprite('start.png',(68,178,142),473,295,0)]
    startscreen[0].fadein(30)
    (startscreen[1].rot.offset, startscreen[1].xscale.offset, startscreen[1].yscale.offset) = (15.0, 2.0, 2.0)
    startscreen[1].rotate(-15.0,15,2,0.0,startscreen[0])
    startscreen[1].scale(-1.0,-1.0,15,2,0.0,startscreen[0])
    startscreen[2].movepos(-50,0,5,2,0.0, startscreen[2].movepos(-50,0,45,0,0.0, startscreen[2].movepos(-300,0,20,1,15.0,startscreen[1])[0] )[0] )
    startscreen[3].movepos(0,150,10,2,0.0,startscreen[2])
    startscreen[4].movepos(200,0,10,2,0.0,startscreen[3])
    startscreen[5].movepos(0,-160,10,2,0.0,startscreen[4])
    startscreen[6].rotate(360.0,15,2,5.0,startscreen[5])
    startscreen[6].fadein(15,5.0,startscreen[5])
    clock = pygame.time.Clock()
    event = silenEvent()
    screenfsflag = False
    while startscreen[6].active():
        event.update()
        if event.fsflag:
            (event.fsflag,screenfsflag) = (False,not screenfsflag)
            if screenfsflag: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            else: screen = pygame.display.set_mode(size)
        screen.fill((0,0,0))
        for sprite in startscreen:
            sprite.update()
            screen.blit(sprite(),sprite.rect,sprite.area_rect())
        pygame.display.flip()
        clock.tick(30)
    startscreen[7].fadein(45,15.0,None,True,True)
    while 1:
        event.update()
        if event.fsflag:
            (event.fsflag,screenfsflag) = (False,not screenfsflag)
            if screenfsflag: screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
            else: screen = pygame.display.set_mode(size)
        screen.fill((0,0,0))
        for sprite in startscreen:
            sprite.update()
            screen.blit(sprite(),sprite.rect,sprite.area_rect())
        pygame.display.flip()
        clock.tick(30)
    raise SystemExit()
"""
if __name__ == '__main__': main()
"""    test = silenAnimVar(25,100,3)
    print test()
    for i in range(25):
        test.update(1)
        print test()
    test2 = silenLinCtr(5,True)
    print test2()
    for i in range(26):
        test2.update(1)
        print test2()
    test3 = silenPicDelay([1,2,3,4,5,6,1,1,1],Rect(0,0,96,96),3,3)
    print '\n',test3()
    for i in range(26):
        test3.update(1)
        print test3()
    test4 = silenVar(50)
    test4.add(25,100,3)
    print test4()
    for i in range(25):
        test4.update()
        print test4()
    raise SystemExit()
"""
"""
    pygame.init()
    pygame.display.set_caption('silen v0.1')
    pygame.mouse.set_visible(0)
    size = width, height =  640, 480
    screen = pygame.display.set_mode(size) # create here so events work
"""
"""
for event in pygame.event.get():
    if event.type == pygame.KEYDOWN:
        print event.key
        if event.key == pygame.K_ESCAPE: raise SystemExit()
"""

"""
class Creator:
    def __init__(self):
        self.dirt_img, self.dirt_img_rect = load_image("dirt.png")
        self.turret_img, self.turret_img_rect = load_image("flamethrower.png")
        self.turret_img_r, self.turret_img_rect_r = load_image("flamethrower_r.png")
        self.wall_img, self.wall_img_rect = load_image("brick.png")
        self.goal_img, self.goal_img_rect = load_image("target.png")
        self.grass_img, self.grass_img_rect = load_image("grass.png")
    def __call__(self, value):
        if value == "1": return GrassBlock(self.grass_img)
        elif value == "2": return WallBlock(self.wall_img)
        elif value == "3": return DirtBlock(self.dirt_img)
        elif value == "5": return TurretBlock(self.turret_img,1)
        elif value == "6": return TurretBlock(self.turret_img_r,-1)
        elif value == "7": return GoalBlock(self.goal_img)
        elif int(value) >= 10: return TrapBlock(self.dirt_img,self.wall_img,int(value))
        else: return EmptyBlock() #value == "0" or invalid
create_block = Creator()
class Grid:
    def __init__(self, file_name):
        self.valid = True
        self.move_counter = 0
        self.move_digtime = 0
        self.move_x = 0
        self.move_y = 0
        self.move_direction = -1
        self.still_alive = True
        self.win = False
        self.timer = -1
        self.real_x = 0
        self.real_y = 0
        self.width = 20
        self.height = 15
        self.settimer = 900
        self.rows = []
        # intitialize map
        try: fd = open(os.path.join("data",file_name))
        except IOError:
            self.valid = False
            return
        regread = re.compile(r"\d+") # any number of numeric characters (greedy)
        line = fd.readline()
        data = regread.findall(line) # ignore any amount of whitespace and text in first line
        if len(data) < 2: # first line should have width, height, and (possibly) timer frames
            self.valid = False
            return
        self.width = int(data[0])
        self.height = int(data[1])
        if len(data) >= 3: self.settimer = int(data[2])
        data = []
        for i in range(self.height):
            line = fd.readline()
            data = regread.findall(line) # ignore any amount of whitespace and text in file
            if len(data) < self.width: # if there aren't enough numbers in the line, quit
                self.valid = False
                return
            row = [create_block(data[j]) for j in range(self.width)]
            self.rows.append(row)
    def draw(self, screen):
        y = 240 - self.real_y
        ypos = 0
        for row in self.rows:
            x = 320 - self.real_x
            xpos = 0
            for block in row:
                block.draw(screen, x, y)
                if block.is_active() and block.get_facing() == -1:
                    if ypos == int((self.real_y+16)/32) and  xpos - 3 <= int((self.real_x+16)/32) and int((self.real_x+16)/32) <= xpos:
                        self.still_alive = False
                        return
                if block.is_active() and block.get_facing() == 1:
                    if ypos == int((self.real_y+16)/32) and  xpos <= int((self.real_x+16)/32) and int((self.real_x+16)/32) <= xpos + 3:
                        self.still_alive = False
                        return
                xpos += 1
                x += 32
            ypos += 1
            y += 32
        draw_shroud(screen)
        row = self.rows[0]
        y = 240 - self.real_y
        x = 320 - self.real_x
        for block in row:
            block.draw(screen, x, y)
            x += 32
        if self.timer != -1:
            my_font = pygame.font.Font('data/quartzitalic.ttf',64)
            if (self.timer%30)*2 < 10: screen.blit(my_font.render('%i:0%i' % (self.timer/30, (self.timer%30)*2),True,(0,255,0)),(0,0))
            else: screen.blit(my_font.render('%i:%i' % (self.timer/30, (self.timer%30)*2),True,(0,255,0)),(0,0))
    def update(self):
        if self.timer != -1:
            if self.real_y == 0:
                self.win = True
                return
            elif self.timer == 0:
                self.still_alive = False
                return
            else: self.timer -= 1
        elif self.rows[int(self.real_y/32)][int(self.real_x/32)].is_goal() and self.timer == -1: self.timer = self.settimer
        if self.move_digtime > 1: self.move_digtime -=1
        elif self.move_digtime == 1: # kill block
            self.move_digtime = 0
            if self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)].is_trap():
                for row in self.rows:
                    for curblock in row:
                        if curblock.is_trap() and self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)].trapnum == curblock.trapnum:
                            curblock.triggered = True
            elif self.real_y+self.move_y*4 == 0: self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)] = create_block("1")
            else: self.rows[int(self.real_y/32+self.move_y/8)][int(self.real_x/32+self.move_x/8)] = EmptyBlock()
        elif self.move_counter > 0: # fluid movement
            #(add_x,add_y) = (int(self.move_x/self.move_counter),int(self.move_y/self.move_counter))
            #(self.move_x,self.move_y)=(self.move_x-add_x,self.move_y-add_y)
            (self.real_x,self.real_y)=(self.real_x+self.move_x,self.real_y+self.move_y)
            self.move_counter -=1
        return
    def is_passable(self,x,y): return x >= 0 and x < self.width and y >= 0 and y < self.height and self.rows[y][x].is_passable()
    def is_diggable(self,x,y): return x >= 0 and x < self.width and y >= 0 and y < self.height and self.rows[y][x].is_diggable()
    def move(self,delta_x,delta_y):
        if self.move_counter == 0:
            target_x = int(self.real_x/32) + delta_x
            target_y = int(self.real_y/32) + delta_y
            if self.is_passable(target_x,target_y): (self.move_x,self.move_y,self.move_counter) = (delta_x*8,delta_y*8,4)
            elif self.is_diggable(target_x,target_y): (self.move_x,self.move_y,self.move_counter,self.move_digtime) = (delta_x*8,delta_y*8,4,3)
    def cancel_move(self):
        if(self.move_digtime > 0): (self.move_digtime,self.move_counter) = (0,0)
class Digger:
    def __init__(self):
        self.x = 0
        self.y = 0
        self.img, self.img_rect = load_image("test.png")
        self.grass_img, self.grass_img_rect = load_image("snake_grass.png")
    def draw(self, screen):
        screen.blit(self.img,(320+self.x*32,240+self.y*32))
def lose(screen):
    #print "LOSE"
    lose_img, lose_img_rect = load_image("lose.png")
    screen.blit(lose_img,(0,0))
def win(screen):
    #print "WIN"
    img, img_rect = load_image("win.png")
    screen.blit(img,(0,0))
def intro(screen):
    #print "WIN"
    img, img_rect = load_image("intro.png")
    screen.blit(img,(0,0))
def draw_shroud(screen):
    img, img_rect = load_image("fow.png")
    screen.blit(img,(0,0))
def build_level(level):
    return Grid("Level%s.txt" % level)
class GameManager:
    def __init__(self):
        self.start = False
        self.screen = pygame.display.set_mode(size)
        self.black = 0, 0, 0
        self.fstoggle = False
        self.background, self.background_rect = load_image("black.png")
        self.clock = pygame.time.Clock()
        self.keydown = [False,False,False,False]
        self.timer = 0
        self.score = 0
        self.level = 1
        self.player = Digger()
        self.move_counter = 0
        self.grid = None
        self.skipintro = False
        self.screen.blit(self.background, (0, 0))
        pygame.display.flip()
        pygame.mixer.init()
        pygame.mixer.music.load('data/UndergroundMix.mp3')
        pygame.mixer.music.play(-1)
    def common_events(self,event):
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F1:
                if self.fstoggle: self.screen = pygame.display.set_mode(size)
                else: self.screen = pygame.display.set_mode(size,pygame.FULLSCREEN|pygame.DOUBLEBUF|pygame.HWSURFACE|pygame.NOFRAME)
                self.fstoggle = not self.fstoggle
                return True
        return False
    def loop(self):
        while not self.start and not self.skipintro:
            intro(self.screen)
            pygame.display.flip()
            self.clock.tick(30)
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_c: self.start = True # continue
                    else: (self.level,self.start) = (1,True) # restart
        self.skipintro = False
        self.grid = build_level(self.level)
        if not self.grid.valid: raise SystemExit() # finished the available levels
        while self.grid.still_alive and not self.grid.win:
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key >= 273 and event.key <= 276: self.keydown[event.key-273] = True # arrow keys
                elif event.type == pygame.KEYUP:
                    if event.key >= 273 and event.key <= 276:
                        self.keydown[event.key-273] = False # arrow keys
                        self.grid.cancel_move()
            if self.keydown[0]: self.grid.move(0,-1)
            elif self.keydown[1]: self.grid.move(0,1)
            elif self.keydown[2]: self.grid.move(1,0)
            elif self.keydown[3]: self.grid.move(-1,0)
            self.clock.tick(30)
            self.screen.blit(self.background, (0,0))
            self.grid.update()
            self.grid.draw(self.screen)
            self.player.draw(self.screen)
            pygame.display.flip()
        self.keydown = [False,False,False,False] # incase player was holding down a key when they died
        self.start = False
        while not self.start:
            self.clock.tick(30)
            if self.grid.win: win(self.screen)
            else: lose(self.screen)
            for event in pygame.event.get():
                if self.common_events(event): pass
                elif event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_c: (self.start,self.skipintro) = (True,True) # continue
                    else: self.start = True
            pygame.display.flip()
        if self.grid.win: self.level += 1
        else: self.start = False
"""
