# silen v0.1
import pygame, sys, os, re
from pygame.locals import *

class silenEvent:
    def __init__(self):
        self.keydb = {}
        self.fsflag = False
    def getkey(self,key): #get a key from silenEvent, the right way (getkey(key))
        if key in self.keydb: return self.keydb[key] and True or False #maintains validity of result, even with ints in dictionary
        return False #if key isn't in keydb, it hasn't been pressed
    def getkeyu(self,key): #getkey and untrigger it immediately
        if key in self.keydb:
            if self.keydb[key]:
                self.keydb[key] = False
                return True
        return False
    def getkeyd(self,key,x): #getkey with delay, only returns true every x times queried
        if key in self.keydb:
            if self.keydb[key]:
                self.keydb[key] -= 1 #since True==1 and False==0, this works initially
                if not self.keydb[key]: #False means timer has counted down to 0
                    self.keydb[key] = x #restart timer
                    return True
        return False
    def getkeys(self,keylist): #get a list of keys, returning True if any are pressed
        for key in keylist:
            if key in self.keydb and self.keydb[key]: return True
        return False
    def getkeysu(self,keylist): #get a list of keys and untrigger all, then return True if any were pressed
        rtn = False
        for key in keylist:
            if key in self.keydb and self.keydb[key]:
                self.keydb[key] = False
                rtn = True
        return rtn
    #def getkeysd(self,keylist,x): #get a list of keys, updating all delays to x if 1, then return True if any were pressed
    #def getfkey(self,keylist): #same as getkeys, but returns first key in set that was True, or None
    def getfkeyu(self,keylist): #same as getkeysu, but returns first key in set that was True, or None
        rtn = None
        for key in keylist:
            if key in self.keydb and self.keydb[key]:
                self.keydb[key] = False
                rtn = key
        return rtn
    #def getfkeyd(self,keylist,x): #same as getkeysd, but returns first key in set that was True, or None
    def untrigger(self,key): self.keydb[key] = False
    def trigger(self,key): self.keydb[key] = True
    def reset(self): #effectively sets all pressed keys to False, and clears event stack
        self.keydb.clear()
        pygame.event.get()
    def runone(self,event): #run a single event
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE: raise SystemExit()
            elif event.key == pygame.K_F1: self.fsflag = True #handled in silenScreen
            else: self.keydb[event.key] = True #all other keys are handled in self.keydb
        elif event.type == pygame.KEYUP:
            if event.key == pygame.K_ESCAPE or event.key == pygame.K_F1: pass #ignore these keys
            else: self.keydb[event.key] = False #all other keys handled in self.keydb
    def update(self): #loop for all events
        for event in pygame.event.get(): self.runone(event)
