# silen v0.2 (stable)
import pygame, sys, os
from pygame.locals import *
from sprite import *
from event import *

pygame.font.init()
silenmanabsescfont = pygame.font.Font(os.path.dirname(__file__)+'/uni05_53.ttf',20)
class Manager:
    escmenu = None
    def __init__(self,title,resetargs=None,fsflag=False,bkgfill=(0,0,0)):
        pygame.init()
        self.title = title
        self.resetargs = resetargs
        pygame.display.set_caption(title)
        pygame.mouse.set_visible(0)
        self.event = Event(self)
        self.sprites = [] #silen.Sprite()s that should be drawn to the screen
        self.bkgfill = bkgfill #the fill to draw on the screen first
        self.screen = pygame.display.set_mode((640,480))
        self.setfsmode(fsflag)
        self.clock = pygame.time.Clock()
        if self.__class__.escmenu == None: #initialize first time (pygame must be initialized first)
            self.__class__.escmenu = pygame.Surface((800,600)).convert() #default filled black
            tempfont = silenmanabsescfont
            temptext = tempfont.render("Press ESC to quit.",False,(255,0,0))
            self.__class__.escmenu.blit(temptext,temptext.get_rect(topleft=(20,20)))
            temptext = tempfont.render("Press F1 to cancel.",False,(0,0,255))
            self.__class__.escmenu.blit(temptext,temptext.get_rect(topleft=(20,50)))
            if resetargs:
                temptext = tempfont.render("Press F2 to reset.",False,(255,128,0))
                self.__class__.escmenu.blit(temptext,temptext.get_rect(topleft=(20,80)))
            temptext = tempfont.render("Press F4 to toggle fullscreen.",False,(255,255,0))
            self.__class__.escmenu.blit(temptext,temptext.get_rect(topleft=(20,140)))
    def runescmenu(self):
        tempevent = Event() #don't pass the manager so pressing ESC raises SystemExit - otherwise it's an infinite loop
        while tempevent:
            tempevent.update()
            if tempevent.hit(pygame.K_F1): tempevent = None #breaks the loop (cancel)
            elif tempevent.hit(pygame.K_F2) and self.resetargs: os.execv(sys.executable,(sys.executable,)+tuple(self.resetargs)) #reset the game
            elif tempevent.fsflag: tempevent.fsflag = False; self.setfsmode(not self.fsflag); #toggles fullscreen
            self.screen.blit(self.__class__.escmenu,self.__class__.escmenu.get_rect())
            pygame.display.flip()
            self.clock.tick(30)
    def setfsmode(self,fsflag):
        self.fsflag = fsflag
        if fsflag: self.screen = pygame.display.set_mode((800,600),pygame.FULLSCREEN|pygame.NOFRAME)#|pygame.HWSURFACE)
        else: self.screen = pygame.display.set_mode((800,600))
    def draw(self,showfps=False,useclock=True):
        self.screen.fill(self.bkgfill)
        for spr in self.sprites: spr.update(); self.screen.blit(spr.data,spr.rect)
        pygame.display.flip()
        if useclock: self.clock.tick(30)
        else: self.clock.tick()
        if showfps: pygame.display.set_caption(self.title + (" - FPS: %d" % self.clock.get_fps()))
if __name__ == '__main__':
    game = Manager('asdf',[__file__])
    while game:
        game.event.update()
        pygame.display.flip()
        game.clock.tick(30)
