# silen v0.2 (stable)
import pygame, sys, os, re
from pygame.locals import *

class Event:
    def __init__(self,manager=None,fsflag=False):
        self.keydb = {} #for determining if a key is currently down (down)
        self.trigdb = {} #for determining if a key was just pressed (hit)
        self.waitval = 0.0 #an amount of time to return false for all down/hit calls
        self.manager = manager #a silen.Manager class. handles screen, events, sprites, etc.
        self.fsflag = fsflag
    def getkey(self,key): #getkey functions are held tests that don't check wait
        if key in self.keydb: return bool(self.keydb[key])
        return False #if key isn't in keydb, it hasn't been pressed
    def getkeys(self,keylist): #get a list of keys, returning True if any are pressed
        for key in keylist:
            if key in self.keydb and self.keydb[key]: return True
        return False
    def down(self,key,fwait=0.0): #if key is down, add wait # of frames (also checks wait - HL)
        if self.waitval == 0.0 and key in self.keydb and self.keydb[key]: self.waitval += fwait; return True
        return False
    def hit(self,key,fwait=0.0): #if key was just pressed this frame (checks wait - HL)
        if self.waitval == 0.0 and key in self.trigdb and self.trigdb[key]: self.waitval += fwait; return True
        return False
    def lift(self,key): self.keydb[key] = False; self.trigdb[key] = False
    def press(self,key): self.keydb[key] = True; self.trigdb[key] = True
    def runone(self,event): #run a single event
        if event.type == pygame.QUIT: raise SystemExit()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_ESCAPE:
                if self.manager: self.manager.runescmenu()
                else: raise SystemExit() #default is to quit
            elif event.key == pygame.K_F4: #fullscreen toggle
                if self.manager: self.fsflag = not self.fsflag; self.manager.setfsmode(self.fsflag)
                else: self.fsflag = True #default is to flag when to change the fullscreen-ity
            else: self.keydb[event.key] = True; self.trigdb[event.key] = True
        elif event.type == pygame.KEYUP:
            if event.key == pygame.K_ESCAPE or event.key == pygame.K_F4: pass #ignore these keys
            else: self.keydb[event.key] = False
    def update(self,timestep=1.0): #loop for all events
        if self.waitval: self.waitval = max(0.0,self.waitval - timestep)
        self.trigdb.clear() #so that this db only holds currently hit keys
        for event in pygame.event.get(): self.runone(event)
    def reset(self): self.keydb.clear(); self.trigdb.clear(); pygame.event.get(); self.waitval=0.0 #lifts all pressed keys, clears waiting events and wait timer

