import silen.main as silen
import sys,os,math,re,random
import pygame
from pygame.locals import *
game = silen.Manager(title='A Walk in the Park',resetargs=[__file__])
class Difficulty:
    def __init__(self,recoveryamt,birdhp,pooprate,doghp,dogspeed,patrad,bumjumpspeed,bumthrowslow,bumthrowfast):
        self.recoveryamt = recoveryamt
        self.birdhp = birdhp
        self.pooprate = pooprate
        self.doghp = doghp
        self.dogspeed = dogspeed
        self.patrad = patrad
        self.bjumpspeed = bumjumpspeed
        self.bthrowslow = bumthrowslow
        self.bthrowfast = bumthrowfast
diffeasy = Difficulty(0.050,1,5,2,150,300,60,150,100)
diffhard = Difficulty(0.025,2,20,4,90,450,30,100,60)
class HUDIcon:
    def __init__(self,fdata,pos,fdelay=0.0,cdelay=0.0):
        self.sprite = silen.Sprite(0,fdata,pos)
        self.fdelay = fdelay
        self.cdelay = cdelay
    def hit(self): self.cdelay = self.fdelay
    def update(self):
        if self.cdelay: self.cdelay = max(0.0,self.cdelay-1.0); return
        self.sprite.update()
    def draw(self,screen):
        if self.cdelay: #draw the arc reloading
            pygame.draw.arc(screen,(185,185,185),self.sprite.rect,math.pi/2,math.pi/2+2*math.pi*(self.fdelay-self.cdelay)/self.fdelay,25)
            pygame.draw.arc(screen,(255,255,255),self.sprite.rect,math.pi/2,math.pi/2+2*math.pi*(self.fdelay-self.cdelay)/self.fdelay,2)
        else: screen.blit(self.sprite(),self.sprite.rect) #draw the icon
    def active(self): return not self.cdelay
class DataOrganizer:
    def __init__(self):
        self.hp = 100
        self.hpbar = silen.Sprite(3,[(200,20),(0,255,0)],(0,0)) #(x,y) are used as offsets, since we need a fixed topleft corner
        self.hpbaranim = silen.Sprite(3,[(200,20),(255,0,0)],(0,0)) #(x,y) are used as offsets, since we need a fixed topleft corner
        self.hpbar.xscale.offset = 0.0; self.hpbar.scale(1.0,1.0,[30],2)
        self.hpbaranim.xscale.offset = 0.0; self.hpbaranim.scale(1.0,1.0,[30],2)
        self.oldhp = 100
        self.action1 = HUDIcon(['HUDrifle.png',(0,255,104)],(45,520),7.0,0.0)
        self.action2 = HUDIcon(['HUDumbrella.png',(0,255,104)],(110,520),600.0,0.0)
        self.action3 = HUDIcon(['HUDbottle.png',(0,255,104)],(175,520),300.0,300.0) #start delay from use (don't use .hit() afterwards)
        self.bumhp = 160
        self.bhpbar = silen.Sprite(3,[(200,20),(0,255,0)],(0,0)) #(x,y) are used as offsets, since we need a fixed topleft corner
        self.bhpbaranim = silen.Sprite(3,[(200,20),(255,0,0)],(0,0)) #(x,y) are used as offsets, since we need a fixed topleft corner
        self.bhpbar.xscale.offset = 0.0; self.bhpbaranim.xscale.offset = 0.0
        self.oldbhp = 160
        self.gameover = False; self.won = False
    def draw(self,screen): #draws HUD sprites to the screen
        self.action1.update(); self.action2.update(); self.action3.update()
        self.action1.draw(screen); self.action2.draw(screen); self.action3.draw(screen)
        self.hp = max(0,min(100,self.hp))
        if self.hp == 0: self.gameover = True
        if self.hp != self.oldhp:
            self.hpbar.xscale.offset = self.hp/100.0
            if self.hpbaranim.xscale() < self.hpbar.xscale(): self.hpbaranim.scale(self.hp/100.0,1.0,[1],0)
            else: self.hpbaranim.scale(self.hp/100.0,1.0,[20],3,[],[10.0])
            if self.hp < self.oldhp: #took damage, shake bars
                self.hpbaranim.move(4,-2,[1],0,[True]); self.hpbar.move(-4,2,[1],0,[True])
            self.oldhp = self.hp
        self.hpbar.update(); self.hpbaranim.update() #instant green bar / animated decreasing red bar
        if self.bumhp == 0: self.won = True; self.gameover = True
        if self.bumhp != self.oldbhp:
            self.bhpbar.xscale.offset = self.bumhp*0.02375
            if self.bhpbaranim.xscale() < self.bhpbar.xscale(): self.bhpbaranim.scale(self.bumhp*0.02375,1.0,[1],0)
            else: self.bhpbaranim.scale(self.bumhp*0.02375,1.0,[20],3,[],[10.0])
            if self.bumhp < self.oldbhp: #took damage, shake bars
                self.bhpbaranim.move(4,-2,[1],0,[True]); self.bhpbar.move(-4,2,[1],0,[True])
            self.oldbhp = self.bumhp
        self.bhpbar.update(); self.bhpbaranim.update() #instant green bar / animated decreasing red bar
        screen.blit(self.hpbaranim(),self.hpbaranim().get_rect(topleft=(20+self.hpbaranim.cx(),560+self.hpbaranim.cy())))
        screen.blit(self.hpbar(),self.hpbar().get_rect(topleft=(20+self.hpbar.cx(),560+self.hpbar.cy())))
        screen.blit(self.bhpbaranim(),self.bhpbaranim().get_rect(topleft=(20+self.bhpbaranim.cx(),20+self.bhpbaranim.cy())))
        screen.blit(self.bhpbar(),self.bhpbar().get_rect(topleft=(20+self.bhpbar.cx(),20+self.bhpbar.cy())))
data = DataOrganizer()
class BkgLayer:
    bkgs = []
    def __init__(self,preload):
        self.data = pygame.Surface((800,1200)) #a double-size surface, moved at (6px/frame). When at top half, shift top half down, load next 'screen' into top half.
        self.rect = Rect((0,-2),(800,600)) #the current background screen (within the double-size image buffer)
        self.curscreen = 0
        self.baked = pygame.Surface((800,600)) #the baked surface, with background and static objects combined. for distorting the screen (umbrella effect, bullet air).
        self.distort = pygame.Surface((880,660))
        self.numscreens = preload - 1
    def update(self): #draw the background and objects to the self.bdata surface. this is the final screen w/o sprites or distortion.
        if self.rect.top < -2: self.rect.y += 2 #2px/frame @ 30fps = 10sec per screen height
        elif self.curscreen < self.numscreens: #at the top of the double-screen. do some new image loads.
            self.data.blit(self.bkgs[self.curscreen],self.bkgs[self.curscreen].get_rect(top=600))
            self.curscreen += 1 #increment the current screen counter
            self.data.blit(self.bkgs[self.curscreen],self.bkgs[self.curscreen].get_rect())
            self.rect.top = -600
        elif self.rect.top < 0: self.rect.y += 2
        self.baked.blit(self.data,self.rect)
        pygame.transform.scale(self.baked,(880,660),self.distort)
    def moving(self): return self.rect.top < 0
    def skipfive(self):
        self.curscreen = min(self.numscreens-1,self.curscreen+4)
        self.data.blit(self.bkgs[self.curscreen-1],self.bkgs[self.curscreen-1].get_rect(top=600))
        self.data.blit(self.bkgs[self.curscreen],self.bkgs[self.curscreen].get_rect())
        self.rect.top = -600
        return (self.curscreen-1) * -600
bkg = BkgLayer(20)
class SpriteManager: #sort sprites by y on insert. on each update, if y val changes, move up or down accordingly. (by default, compare to oldy+2, since scrolling)
    def __init__(self): self.ls = []; self.next = [] #self.ls = list of sprites, (draw order) sorted. self.next = unsorted list of new next frame sprites
    def insert(self,so): #insert a new sprite into the list, sorted by cy(). (binary sort, so fast)
        if not so.sprite: self.ls.append(so); return
        ysort = so.sprite.rect.bottom + so.skyht
        lo = 0; hi = len(self.ls)
        while lo < hi:
            mid = (lo+hi)//2
            if ysort < self.ls[mid].sprite.rect.bottom + self.ls[mid].skyht: hi = mid
            else: lo = mid+1
        self.ls.insert(lo,so)
    def remove(self,so): #remove a sprite on death from the list
        if not so.sprite:
            for i in xrange(len(self.ls-1,-1,-1)):
                if self.ls[i] == so: self.ls.pop(i); return
            return
        ysort = so.sprite.rect.bottom + so.skyht
        lo = 0; hi = len(self.ls)
        while lo < hi:
            mid = (lo+hi)//2
            if ysort < self.ls[mid].sprite.rect.bottom + self.ls[mid].skyht: hi = mid
            else: lo = mid+1
        self.ls.pop(lo)
    def update(self): #preserve draw order
        for so in self.next: self.insert(so) #fixes bullets breaking order in main list. anything created by sprites should be put here.
        self.next = []
        lslen = len(self.ls)
        for so in self.ls:
            so.yold = so.sprite.rect.bottom + so.skyht + 2; so.update()
        for i in xrange(lslen):
            if self.ls[i].sprite: ynew = self.ls[i].sprite.rect.bottom + self.ls[i].skyht #yold = old y + scroll amt
            else: self.ynew = 1200
            if self.ls[i].yold < ynew: #moved down more than expected
                j=i+1
                while j < len(self.ls): #lower sprites haven't been updated yet
                    if self.ls[j].sprite.rect.bottom + self.ls[j].skyht + 2 >= ynew: j=len(self.ls) #sorted when this is true
                    else: tempspr = self.ls[j]; self.ls[j] = self.ls[j-1]; self.ls[j-1] = tempspr #shift refs until sorted
                    j += 1
            elif self.ls[i].yold > ynew: #moved up more than expected
                j=i-1
                while j > -1: #higher sprites are already updated and sorted
                    if self.ls[j].sprite.rect.bottom + self.ls[j].skyht <= ynew: j=-1 #sorted when this is true
                    else: tempspr = self.ls[j]; self.ls[j] = self.ls[j+1]; self.ls[j+1] = tempspr #shift refs until sorted
                    j -= 1
        i=0
        while i < lslen:
            self.ls[i].collide()
            if self.ls[i].killcond(): self.ls[i].kill(); self.ls.pop(i); lslen -= 1
            else: i += 1
    def draw(self,screen):
        for so in self.ls: so.draw(screen)
    def killall(self):
        for so in self.next: so.kill()
        for so in self.ls: so.kill()
sprs = SpriteManager()
class LevelLoader:
    #line format is: "y=<ybotstart>: <ClassName> <initarg1> ..." "& <silenSprFcnName> <arg1> ...", in order from largest y down
    redefclass = re.compile(r'y=(.+?):(?:\s*\S+)*')
    readdfcn = re.compile(r'&(?:\s*(\S+))*')
    reargs = re.compile(r'\s+')
    def __init__(self,fname):
        self.file = open(fname,'r')
        self.ybot = self.curclass = self.curclassargs = None
        self.silenfcn = self.silenfcnargs = None
        self.line = self.file.readline()
        self.extractcdef()
    def extractcdef(self):
        match = self.__class__.redefclass.match(self.line)
        if match == None: print "Line: %s was not a class definition." % self.line; raise SystemExit(distortrect = Rect(warp.rect.w/2-warp.cx()*1.1,warp.rect.h/2-warp.cy()*1.1,warp.rect.w,warp.rect.h))
        self.ybot = int(match.group(1))
        self.unpackclass(*(self.__class__.reargs.split(self.line)))
    def unpackclass(self,dummy,cclass,*classargs): self.curclass = cclass; self.curclassargs = classargs[0:-1] #last will always be nothing, because str ends in \n.
    def extractmove(self):
        self.line = self.file.readline()
        match = self.__class__.readdfcn.match(self.line)
        if match == None: self.extractcdef(); return False
        self.unpackmove(*(self.__class__.reargs.split(self.line)))
        return True
    def unpackmove(self,dummy,ssfcn,*ssfcnargs): self.silenfcn = ssfcn; self.silenfcnargs = ssfcnargs[0:-1]
    def update(self,ytopscreen):
        while self.ybot >= ytopscreen: #things have entered the screen, or are about to
            nextsprobj = eval(self.curclass + '(' + ','.join(self.curclassargs) + ')')
            while self.extractmove(): eval('nextsprobj.sprite.' + self.silenfcn + '(' + ','.join(self.silenfcnargs) + ')')
            sprs.insert(nextsprobj)
    def skip(self,yval):
        while self.ybot >= yval: #things have entered the screen, or are about to
            while self.extractmove(): pass
lldr = LevelLoader("level.txt")
"""-----------------------------------------------------------------------start sprite objects--------------------------------------------------------------------------"""
class SpriteObj(pygame.sprite.Sprite): #all the objects/enemies/projectiles on the background inherit from this class.
    cglist = [pygame.sprite.Group(),pygame.sprite.Group(),pygame.sprite.Group(),pygame.sprite.Group()] #loplr,hiplr,loen,hien
    colrect = lambda so1,so2: so1.colrect.colliderect(so2.colrect)
    def colfcn(self,so1,so2):
        if so1.coltype == 1: return self.colcir(so2,so1)
        if so2.coltype == 1: return self.colcir(so1,so2)
        return self.__class__.colrect(so1,so2)
    def colcir(self,so1,so2): #SpriteObj two has a circular collision region
        if so2.crdata: (cx,cy,cr) = so2.crdata #if crdata exists, it is actually a tuple containing (x,y,radius)
        else: cx = so2.sprite.cx(); cy = so2.sprite.cy(); cr = so2.sprite.rect.w/2 #no crdata - use sprite values
        if so1.colrect.collidepoint(cx,cy): return True #circle center is in colrect, quit immediately
        if cx < so1.colrect.left: rx = so1.colrect.left
        elif cx > so1.colrect.right: rx = so1.colrect.right
        else: return so1.colrect.collidepoint(cx,cy + (int(so1.colrect.top > cy)*2-1)*so2.sprite.rect.h/2)
        if cy < so1.colrect.top: ry = so1.colrect.top
        elif cy > so1.colrect.bottom: ry = so1.colrect.bottom
        else: return so1.colrect.collidepoint(cx + (int(so1.colrect.left > cx)*2-1)*so2.sprite.rect.w/2,cy)
        return math.hypot(rx-cx,ry-cy) < cr #is radius > distance from closest pt to center? (collision test)
    def __init__(self): pass #defined by derived
    """self.sprite = sprite #the silen.Sprite of the object. manages animation, surface, and image rect
        self.colrect = colrect #the collision rect (a pygame.Rect object). None means eval a circle.
        self.crdata = crdata #either (coltype=0: (cxoffset,cyoffset), coltype=1: (cxoffset,cyoffset,radius) | None means calc from sprite rect
        self.skyht = skyht #the distance off the ground the object is. in the SpriteManager, objects are sorted by sprite.rect.bottom + skyht.
        self.colgroup = colgroup #the groups to collide with, in order of importance (most to least)
        self.coltype = coltype #what type of collision is appropriate for this SpriteObj"""
    def collide(self):
        if not self.colgroup: return
        for spr in pygame.sprite.spritecollide(self,self.colgroup,False,self.colfcn):
            if self.resolvea(spr,self.colgroup) or spr.resolveb(self,self.colgroup): return
    def resolvea(self,sprite,group): return False #resolve collision based on the type of the object (or its group) - defined in derived classes
    def resolveb(self,sprite,group): return False #for the collidee (lower level object) to know what's going on
    def update(self):
        self.oldcx = self.sprite.cx(); self.oldcy = self.sprite.cy()
        self.sprite.update()
        if self.coltype: self.crdata[0:2] = (self.sprite.cx(),self.sprite.cy())
        else: self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
    def undomove(self):
        #self.sprite.cx.offset -= self.sprite.cx() - self.oldcx; self.sprite.cy.offset -= self.sprite.cy() - self.oldcy
        self.sprite.cx.end(); self.sprite.cy.end(); self.sprite.cx.offset = self.oldcx; self.sprite.cy.offset = self.oldcy #clear animations, as they are no longer valid.
        if self.coltype: self.crdata[0:2] = (self.sprite.cx(),self.sprite.cy())
        else: self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
    def draw(self,screen):
        screen.blit(self.sprite(),self.sprite.rect)
        #asdf = pygame.surface.Surface(self.colrect.size); screen.blit(asdf,self.colrect)
    def killcond(self): return not self.sprite.active()
"""player-oriented SpriteObjects"""
class SOBulletImpact(SpriteObj):
    def __init__(self,pos):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        self.sprite = silen.Sprite(1,["impact.png"],pos)
        self.sprite.makeanim([1,1,1,1],[(64,16),4,1])
        self.colrect = Rect(pos,(8,16)); self.crdata = (0,0); self.skyht = 0
        self.coltype = 0; self.colgroup = None
        self.killtime = 4
    def update(self): self.sprite.update(); self.killtime = max(0,self.killtime-1)
    def collide(self): pass
    def killcond(self): return self.killtime <= 0
class SOBullet(SpriteObj):
    warpimage = None
    def __init__(self,pos):
        if self.__class__.warpimage == None: self.__class__.warpimage = pygame.image.load("bulletsw.png").convert_alpha()
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        self.sprite = silen.Sprite(0,["bullet.png",(68,178,142)],pos)
        self.warp = silen.Sprite(2,[self.__class__.warpimage],(pos[0],pos[1]+291))
        self.warparearect = Rect(0,0,32,16)
        self.sprite.move(0,-1200,[60],0); self.warp.move(0,-1200,[60],0)
        self.colrect = Rect(pos,(8,16)); self.crdata = (0,0); self.skyht = 0
        self.coltype = 0; self.colgroup = None; self.add(self.cglist[2],self.cglist[3]) #add to loen and hien tests
        self.contact = False
    def update(self):
        self.oldcx = self.sprite.cx(); self.oldcy = self.sprite.cy()
        self.sprite.update(); self.warp.update()
        self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
        self.warparearect.h = min(600,self.warparearect.h + self.oldcy - self.sprite.cy())
    def draw(self,screen):
        distortrect = Rect((self.warp.rect.w/2-self.warp.cx()*1.1,self.warp.rect.h/2-self.warp.cy()*1.1),self.warp.rect.size)
        self.warp.data.blit(bkg.distort,distortrect,None,pygame.BLEND_RGB_MIN)
        self.warp.data.fill((0,5,10),self.warparearect,pygame.BLEND_RGB_ADD)
        screen.blit(self.warp(),self.warp.rect,self.warparearect)
        screen.blit(self.sprite(),self.sprite.rect)
    def resolveb(self,sprite,group):
        if not isinstance(sprite,SOBulletNOHIT): sprs.next.append(SOBulletImpact(self.sprite.rect.center)); self.contact = True
    def killcond(self): return not self.sprite.active() or self.contact
class SOUmbrellaSW(SpriteObj):
    def __init__(self,pos):
        pygame.sprite.Sprite.__init__(self)
        self.yold = 0
        self.sprite = silen.Sprite(1,['warpcircle.png'],pos)
        self.sprite.xscale.offset = 0.0; self.sprite.yscale.offset = 0.0
        self.sprite.changepic(True)
        self.sprite.scale(1.5,1.5,[60],3,[True,False])
        self.colrect = Rect(pos,(0,0)); self.crdata = None; self.skyht = 300
        self.coltype = 1; self.colgroup = None; self.add(self.cglist[2],self.cglist[3]) #add to loen and hien tests
    def update(self): self.sprite.update()
    def draw(self,screen):
        distortrect = Rect((self.sprite.rect.w/2-self.sprite.cx()*1.1,self.sprite.rect.h/2-self.sprite.cy()*1.1),self.sprite.rect.size)
        self.sprite.data.blit(bkg.distort,distortrect,None,pygame.BLEND_RGB_MIN)
        self.sprite.data.fill((10,10,0),None,pygame.BLEND_RGB_ADD)
        screen.blit(self.sprite(),self.sprite.rect)
class SOHiPlr(SpriteObj):
    def __init__(self):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        self.sprite = silen.Sprite(1,["guyhi.png"],(400,520))
        self.sprite.makeanim([2,2,2,2,2,2, 0,0, 3,3,3,102,3,3,3,1, 2,2,2,2, 10,10,10,10, 2,2,2,2],[(256,672),4,7],[],False)
        self.colrect = Rect((400,522),(32,85)); self.crdata = (0,2); self.skyht = 0
        self.coltype = 0; self.colgroup = self.cglist[1] #this is the hiplr (highest level tester, so no add)
    def draw(self,screen): pass #so the player manager can handle both
    def update(self): pass
    def collide(self): pass
    def collide_internal(self,pman):
        if not self.colgroup: return
        for spr in pygame.sprite.spritecollide(self,self.colgroup,False,self.colfcn):
            if pman.resolvea(spr,self.colgroup) or spr.resolveb(self,self.colgroup): return
    def resolvea(self,sprite,group): return False
    def killcond(self): return False
class PlayerManager(SpriteObj): #handles two SpriteObj()s (torso & legs), and all player controls.
    def __init__(self):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        self.hiso = SOHiPlr(); sprs.insert(self.hiso)
        self.sprite = silen.Sprite(0,["guylo.png",(68,178,142)],(400,520)) #legs
        self.sprite.makeanim([0,0,0,0,0,0,0,0, 5,5,5,5,5,5,5,5, 3,3,3,3,3,3,3,3, 5,5,5,5,5,5,5,5, 5,5,5,5,5,5,5,5,
                              5,5,5,5,5,5,5,5, 5,5,5,5,5,5,5,5, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3],[(512,864),8,9],[8,8,16],True)
        self.colrect = Rect((402,558),(25,12))
        self.crdata = (2,38)
        self.skyht = 0
        self.coltype = 0
        self.colgroup = self.cglist[0] #this is the loplr
        self.oldcx = 400
        self.oldcy = 520
        self.invind = 0.0
        self.dir = 5
        self.drunk = False
    def losehp(self,amt):
        if not self.invind:
            self.invind = 120.0
            data.hp -= amt
    def update(self,timestep=1.0):
        self.invind = max(0.0,self.invind - 1.0)
        self.oldcx = self.sprite.cx(); self.oldcy = self.sprite.cy()
        curdir = 5 #cast to the numpad dirs
        if game.event.down(pygame.K_DOWN): curdir -= 3
        elif game.event.down(pygame.K_UP): curdir += 3
        if game.event.down(pygame.K_LEFT): curdir -= 1
        elif game.event.down(pygame.K_RIGHT): curdir += 1
        ymove,xmove = divmod(curdir-1,3) #movement vars
        if ymove < 1:
            if self.sprite.rect.bottom < 580: self.sprite.cy.offset += 2; self.hiso.sprite.cy.offset += 2
            elif not self.drunk: curdir = (curdir-1)%3+4 #to account for -2,-1,0 possibilities
        elif ymove > 1:
            if self.sprite.rect.top > 280: self.sprite.cy.offset -= 2; self.hiso.sprite.cy.offset -= 2
            elif not self.drunk: curdir -= 3
        if xmove < 1:
            if (not self.drunk and self.sprite.rect.left > 20) or self.sprite.rect.left > 120: self.sprite.cx.offset -= 4; self.hiso.sprite.cx.offset -= 4
            elif not self.drunk: curdir += 1
        elif xmove > 1:
            if (not self.drunk and self.sprite.rect.right < 780) or self.sprite.rect.right < 680: self.sprite.cx.offset += 4; self.hiso.sprite.cx.offset += 4
            elif not self.drunk: curdir -= 1
        if not bkg.moving(): curdir -= 3 #when the screen stops scrolling at the boss fight, animations shift down in speed
        if curdir != self.dir: #leg animation
            self.dir = curdir
            if curdir == 5: self.sprite.pframe.setanimrange(15,8,16,active=True)
            elif curdir == 4: self.sprite.pframe.setanimrange(53,48,56,active=True)
            elif curdir == 6: self.sprite.pframe.setanimrange(42,40,48,active=True)
            elif curdir == 8: self.sprite.pframe.setanimrange(23,16,24,active=True)
            elif curdir == 7: self.sprite.pframe.setanimrange(69,64,72,active=True)
            elif curdir == 9: self.sprite.pframe.setanimrange(58,56,64,active=True)
            elif curdir == 2: self.sprite.pframe.setanimrange(0,0,8,active=False)
            elif curdir == 1: self.sprite.pframe.setanimrange(33,32,40,active=True)
            elif curdir == 3: self.sprite.pframe.setanimrange(25,24,32,active=True)
            elif curdir == -1: self.sprite.pframe.setanimrange(15,15,7,animdir=-1,active=True)
            elif curdir == -2: self.sprite.pframe.setanimrange(42,47,39,animdir=-1,active=True)
            elif curdir == 0: self.sprite.pframe.setanimrange(53,55,47,animdir=-1,active=True)
        if game.event.down(pygame.K_c) and data.action3.active(): #don't hit, since no recovery after initial boot time
            if not self.drunk:
                pygame.mixer.Sound("sound/drinking.wav").play()
                self.hiso.sprite.pframe.setanimrange(16,20,24,active=True)
                self.sprite.move(100,0,[30,0,15*int(self.sprite.cx.offset > 70)+15*int(self.sprite.cx.offset > 730)],3,[True,True])
                self.hiso.sprite.move(100,0,[30,0,15*int(self.sprite.cx.offset > 70)+15*int(self.sprite.cx.offset > 730)],3,[True,True])
                if self.sprite.cx.offset > 730: self.sprite.cx.offset -= 50; self.hiso.sprite.cx.offset -= 50
                if self.sprite.cx.offset > 70: self.sprite.cx.offset -= 50; self.hiso.sprite.cx.offset -= 50
                data.action3.sprite.alpha.add([15],-128,0,[True,True])
                self.drunk = True
            if 20 <= self.hiso.sprite.pframe.ix < 24: data.hp += gamediff.recoveryamt
        else:
            if self.drunk:
                self.hiso.sprite.pframe.setanimrange(24,0,28,0,active=True)
                self.drunk = False; self.sprite.cx.cut(); self.hiso.sprite.cx.cut()
                data.action3.sprite.alpha.cut(); data.action3.sprite.alpha.offset = 255
            if game.event.down(pygame.K_z) and data.action1.active():
                data.action1.hit()
                self.hiso.sprite.pframe.setanimrange(1,0,5,0,active=True)
                sprs.next.append(SOBullet((self.sprite.cx()+12,self.sprite.cy())))
            if game.event.down(pygame.K_x) and data.action2.active():
                pygame.mixer.Sound("sound/whoosh.wav").play()
                data.action2.hit()
                self.hiso.sprite.pframe.setanimrange(8,8,16,15,active=True)
                sprs.next.append(SOUmbrellaSW((self.sprite.cx(),self.sprite.cy()-20)))
                game.event.waitval = 120.0
        self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
        self.hiso.colrect.center = (self.hiso.sprite.cx() + self.hiso.crdata[0],self.hiso.sprite.cy() + self.hiso.crdata[1])
        ###if loplr collided with trees or rocks, revert back to old cx,cy
        self.invind = max(0.0,self.invind-timestep)
        self.collide_internal(); self.hiso.collide_internal(self)
        self.sprite.update(); self.hiso.sprite.update() #for animation/effects/hacked movement
    def collide(self): pass
    def collide_internal(self):
        if not self.colgroup: return
        for spr in pygame.sprite.spritecollide(self,self.colgroup,False,self.colfcn):
            if self.resolvea(spr,self.colgroup) or spr.resolveb(self,self.colgroup): return
    def resolvea(self,sprite,group):
        if not self.invind: #is the player temporarily invincible?
            if not isinstance(sprite,SOPatrol): self.invind = 120.0; data.hp -= 10; pygame.mixer.Sound("sound/ouch2.wav").play()
        return False
    def draw(self,screen):
        if self.invind % 30 < 15: #so the player flickers when hurt
            screen.blit(self.sprite(),self.sprite.rect)
            screen.blit(self.hiso.sprite(),self.hiso.sprite.rect)
        #asdf = pygame.surface.Surface(self.colrect.size); screen.blit(asdf,self.colrect)
        #asdf = pygame.surface.Surface(self.hiso.colrect.size); screen.blit(asdf,self.hiso.colrect)
    def killcond(self): return False
player = PlayerManager(); sprs.insert(player)
"""obstacles and enemy SpriteObjects"""
class SOBulletNOHIT:
    def __init__(self): pass
class SORock(SpriteObj,SOBulletNOHIT): #the rock obstacle
    image = None
    def __init__(self,pos):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        if self.__class__.image == None: self.__class__.image = pygame.image.load("rock.png").convert_alpha()
        self.sprite = silen.Sprite(2,[self.__class__.image],pos)
        self.colrect = Rect(pos[0],pos[1]+8,32,16); self.crdata = (0,8); self.skyht = 0
        self.coltype = 0; self.colgroup = None; self.add(self.cglist[0],self.cglist[2]) #add to loplr and loen tests
    def killcond(self): return not self.sprite.active()
class SOTree(SpriteObj,SOBulletNOHIT): #the four tree obstacles
    image = None
    def __init__(self,ttype,pos):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        if self.__class__.image == None: self.__class__.image = [pygame.image.load("treecherry.png").convert_alpha(),pygame.image.load("treemaple.png").convert_alpha(),
                                                                 pygame.image.load("treepine.png").convert_alpha(),pygame.image.load("treered.png").convert_alpha()]
        self.sprite = silen.Sprite(2,[self.__class__.image[ttype]],pos)
        if ttype == 0: self.colrect = Rect(pos[0]+4,pos[1]+121,66,16); self.crdata = (4,121); self.skyht = -15 #cherry tree
        elif ttype == 1: self.colrect = Rect(pos[0]+15,pos[1]+118,66,16); self.crdata = (15,118); self.skyht = -18 #maple tree
        elif ttype == 2: self.colrect = Rect(pos[0]+1,pos[1]+150,66,16); self.crdata = (1,150); self.skyht = -18 #pine tree
        else: self.colrect = Rect(pos[0],pos[1]+130,66,16); self.crdata = (0,130); self.skyht = -22 #red tree
        self.coltype = 0; self.colgroup = None; self.add(self.cglist[0],self.cglist[2]) #add to loplr and loen tests
    def killcond(self): return not self.sprite.active()
class SOBench(SpriteObj,SOBulletNOHIT): #the two bench obstacles
    image = None
    def __init__(self,btype,pos):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        if self.__class__.image == None: self.__class__.image = [pygame.image.load("benchf.png").convert_alpha(),pygame.image.load("benchs.png").convert_alpha()]
        self.sprite = silen.Sprite(2,[self.__class__.image[btype]],pos)
        if btype == 0: self.colrect = Rect(pos[0]-1,pos[1]+21,117,12); self.crdata = (-1,21); self.skyht = -6 #front bench
        else: self.colrect = Rect(pos[0]+2,pos[1]+24,43,12); self.crdata = (2,24); self.skyht = 0 #side bench #+20+6
        self.coltype = 0; self.colgroup = None; self.add(self.cglist[0],self.cglist[2]) #add to loplr and loen tests
    def killcond(self): return not self.sprite.active()
class SOPoop(SpriteObj,SOBulletNOHIT): #the bird poop (handles both sky and ground cases)
    image = None
    def __init__(self,pos,endpos,ftime):
        pygame.sprite.Sprite.__init__(self)
        self.yold = 0
        if self.__class__.image == None: self.__class__.image = pygame.image.load("poopground.png").convert(); self.__class__.image.set_colorkey((68,178,142))
        self.sprite = silen.Sprite(0,["poopsky.png",(68,178,142),128],pos)
        self.sprite.move(endpos[0]-pos[0],ftime*2,[ftime],0) #linear distance traversal
        self.sprite.move(0,endpos[1]-pos[1],[ftime],1) #smooth start fall
        self.altsprite = silen.Sprite(0,["poopshadow.png",(68,178,142),128],(pos[0],endpos[1]))
        self.altsprite.move(endpos[0]-pos[0],ftime*2,[ftime],0) #shadow is ground target y, but moves with x
        self.colrect = Rect(pos[0],pos[1]+3,13,10); self.crdata = (0,3); self.skyht = 100
        self.colgroup = self.cglist[3]; self.coltype = 0; self.add(self.cglist[1]) #add to hiplr tests
        self.killbool = False
    def update(self):
        if not bkg.moving(): self.sprite.cy.cut() #so they stay still at the boss fight
        self.sprite.update()
        if self.altsprite: self.altsprite.update()
        if not self.sprite.active() and self.altsprite: #move to loplr tests
            self.altsprite = None; self.colgroup = None
            self.sprite.alldata = self.__class__.image; self.sprite.changepic(True)
            self.colrect = Rect(self.sprite.cx(),self.sprite.cy()+2,28,24); self.crdata = (0,2); self.skyht = -100
            self.remove(self.cglist[1]); self.add(self.cglist[0])
            disttogo = 617-self.sprite.cy(); disttogo -= disttogo%2 #makes it even
            if disttogo > 0: self.sprite.move(0,disttogo,[disttogo//2],0)
        self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
    def resolvea(self,sprite,group):
        if isinstance(sprite,SOUmbrellaSW): self.killbool = True
    def draw(self,screen):
        if self.altsprite: screen.blit(self.altsprite(),self.altsprite.rect) #shadow
        screen.blit(self.sprite(),self.sprite.rect)
        #asdf = pygame.surface.Surface(self.colrect.size); screen.blit(asdf,self.colrect)
    def killcond(self): return not self.sprite.active() or self.killbool
class SOBird(SpriteObj): #the bird enemy
    image = None
    def __init__(self,pos):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        if self.__class__.image == None: self.__class__.image = pygame.image.load("bird.png").convert_alpha()
        self.sprite = silen.Sprite(2,[self.__class__.image],pos)
        self.colrect = Rect(pos[0],pos[1]+13,60,15); self.crdata = (0,13); self.skyht = 352
        self.colgroup = self.cglist[3]; self.coltype = 0; self.add(self.cglist[1]) #it's a hien, add to hiplr tests
        self.iflip = False
        self.hp = gamediff.birdhp
    def update(self):
        self.oldcx = self.sprite.cx(); self.oldcy = self.sprite.cy()
        self.sprite.update()
        if self.sprite.cx() < self.oldcx:
            if not self.iflip: self.sprite.xscale.offset = -1.0; self.iflip = True
        elif self.iflip: self.sprite.xscale.offset = 1.0; self.iflip = False
        if self.coltype: self.crdata[0:2] = (self.sprite.cx(),self.sprite.cy())
        else: self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
        if self.sprite.cy() + 200 < player.sprite.cy() and random.randrange(0,1000) < gamediff.pooprate: #aimed crap (1.0% chance per frame)
            sprs.next.append(SOPoop(self.sprite.rect.center,(player.sprite.cx(),player.sprite.cy()-120),60))
    def resolvea(self,sprite,group):
        if isinstance(sprite,SOUmbrellaSW): self.hp = 0
        else: self.hp -= 1
        if self.hp <= 0: pygame.mixer.Sound("sound/hurtbird.wav").play()
        return False
    def killcond(self): return not self.sprite.cy.active() or self.hp <= 0 #since x can loop
class SOPatrol(SpriteObj,SOBulletNOHIT): #the dog patrol region
    def __init__(self,pos,dog):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        self.sprite = silen.Sprite(0,["dummyimage.png",(255,255,255)],pos)
        self.colrect = None; self.crdata = (pos[0],pos[1],gamediff.patrad); self.skyht = 0
        self.coltype = 1; self.colgroup = None; self.add(self.cglist[0]) #add to loplr (dogs chase shoes...)
        self.dog = dog
        self.killbool = False
    def update(self): pass
    def draw(self,screen): pass
    def resolveb(self,sprite,group): self.dog.state = 2; self.killbool = True; return False
    def killcond(self): return self.killbool
class SODog(SpriteObj): #the dog enemy
    image = None
    def __init__(self,pos,thrown=False):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        if self.__class__.image == None: self.__class__.image = pygame.image.load("dog_run.png").convert_alpha()
        self.sprite = silen.Sprite(2,[self.__class__.image],pos)
        self.sprite.makeanim([5,5,5,5, 5,5,5,5, 5,5,5,5, 5,5,5,5, 5,5,5,5],[(256,320),4,5,True],[0,0,4])
        self.colrect = Rect(self.sprite.cx(),self.sprite.cy()+11,30,30); self.crdata = (0,11); self.skyht = 0
        self.coltype = 0; self.colgroup = self.cglist[2]; self.add(self.cglist[0]) #it's a loen, add to loplr tests
        if thrown: self.patrol = None; self.state = 1; self.sprite.pframe.setanimrange(3,3,3,3,active=False)
        else: self.patrol = SOPatrol(pos,self); sprs.next.append(self.patrol); self.state = 0 #0=patrol, 1=wait, 2=target, 3=chase
        self.chasex = self.chasey = 0; self.hp = gamediff.doghp
    def update(self):
        if self.state == 2:
            pygame.mixer.Sound("sound/dogbark.wav").play()
            self.sprite.cx.cut(); self.sprite.cy.cut()
            dx = player.sprite.cx() - self.sprite.cx(); dy = player.sprite.cy() - self.sprite.cy(); dh = math.hypot(dx,dy)
            self.sprite.move(1000*dx/dh,1000*dy/dh,[gamediff.dogspeed],0)
            self.setuprundir(dy,dx)
            self.state = 3
        self.oldcx = self.sprite.cx(); self.oldcy = self.sprite.cy()
        self.sprite.update()
        if self.state == 1 and not self.sprite.active(): #when thrown, target after it lands
            pygame.mixer.Sound("sound/dogbark.wav").play()
            dx = player.sprite.cx() - self.sprite.cx(); dy = player.sprite.cy() - self.sprite.cy(); dh = math.hypot(dx,dy)
            self.sprite.move(1000*dx/dh,1000*dy/dh,[2*gamediff.dogspeed/3.0],0)
            self.setuprundir(dy,dx)
            self.state = 3
        self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
        if self.patrol: self.patrol.crdata = (self.sprite.cx(),self.sprite.cy(),self.patrol.crdata[2])
    def resolvea(self,sprite,group):
        if isinstance(sprite,SOUmbrellaSW): self.hp = 0
        elif isinstance(sprite,SOBullet): self.hp -= 1
        if self.hp <= 0: pygame.mixer.Sound("sound/hurtdog.wav").play()
        return False
    def killcond(self): return not self.sprite.active() or self.hp <= 0
    def setuprundir(self,dy,dx):
        angle = math.atan2(-dy,dx)
        if angle >= 0.5*math.pi or angle < -0.875*math.pi: self.sprite.pframe.setanimrange(12,12,16,active=True)
        elif angle < -0.625*math.pi: self.sprite.pframe.setanimrange(8,8,12,active=True)
        elif angle < -0.375*math.pi: self.sprite.pframe.setanimrange(0,0,4,active=True)
        elif angle < -0.125*math.pi: self.sprite.pframe.setanimrange(4,4,8,active=True)
        else: self.sprite.pframe.setanimrange(16,16,20,active=True)
"""in the process of being completed below this line (also, all sprite objects need kill conditions (not sprite.active() for obstacles?))"""
class SOTrash(SpriteObj): #throwables
    def __init__(self,pos,ftime):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        self.sprite = silen.Sprite(1,["trash.png"],pos)
        self.sprite.makeanim([1,1,1],[(96,32),3,1],[random.randrange(0,3)],False)
        self.sprite.rotate(360,[30],0,[False,True])
        dx = player.sprite.cx() - self.sprite.cx(); dy = player.sprite.cy() - self.sprite.cy(); dh = math.hypot(dx,dy)
        self.sprite.move(1000*dx/dh,1000*dy/dh,[ftime],0)
        self.colrect = Rect(self.sprite.cx(),self.sprite.cy(),16,16); self.crdata = (0,0); self.skyht = 0
        self.coltype = 0; self.colgroup = self.cglist[3]; self.add(self.cglist[1]) #it's a high obstacle
        self.killbool = False
    def resolvea(self,sprite,group):
        if isinstance(sprite,SOUmbrellaSW): self.killbool = True
    def killcond(self): return not (self.sprite.cx.active() or self.sprite.cy.active()) or self.killbool
class SOTrashcan(SpriteObj): #bum's trashcans
    image = None
    def __init__(self,pos):
        pygame.sprite.Sprite.__init__(self)
        self.oldcx = self.oldcy = self.yold = 0
        if self.__class__.image == None: self.__class__.image = pygame.image.load("trashcan.png").convert_alpha()
        self.sprite = silen.Sprite(2,[self.__class__.image],pos)
        self.sprite.makeanim([1,1],[(128,64),2,1],[],False)
        self.colrect = Rect(self.sprite.cx(),self.sprite.cy()+11,30,30); self.crdata = (0,11); self.skyht = -100
        self.coltype = 0; self.colgroup = self.cglist[2] #it's a loen (bullets hit it), but it won't ever hit the player.
        self.hp = 20; self.uinstance = None
    def resolvea(self,sprite,group):
        if self.hp and not self.sprite.active():
            if isinstance(sprite,SOUmbrellaSW) and self.uinstance != sprite: self.hp = max(0,self.hp-10); self.uinstance = sprite
            elif isinstance(sprite,SOBullet): self.hp -= 1
            if self.hp <= 0: self.sprite.pframe.setanimrange(1,1,1,1); pygame.mixer.Sound("sound/trashcanfall.wav").play()
        return False
    def killcond(self): return False #they never die, the game ends first
class SOBum(SpriteObj): #the final boss
    def __init__(self):
        pygame.sprite.Sprite.__init__(self)
        self.yold = 0
        #if self.__class__.image == None: pygame.image.load("dog.png").convert_alpha()
        self.sprite = silen.Sprite(1,["bum_anim.png"],(400,-48))
        self.sprite.makeanim([1, 0,0,0, 5,5,5,5, 5,5,5,5, 5,5,5,5, 2,2,2,2],[(256,480),4,5],[],False)
        self.sprite.move(0,200,[100],0)
        self.colrect = Rect(self.sprite.cx(),self.sprite.cy()+11,30,30); self.crdata = (0,11); self.skyht = 0
        self.coltype = 0; self.colgroup = self.cglist[2] #it's a loen (bullets hit it), but it won't ever hit the player.
        self.cans = []
        for i in range(8): self.cans.append(SOTrashcan((100*i+50,-64))); sprs.next.append(self.cans[-1]); self.cans[-1].sprite.move(0,200,[100],0)
        self.stun = 100.0; self.oldhp = 160; self.state = 0; self.numdead = self.oldndead = 0
        data.bhpbar.scale(3.8,1.0,[30],2,[],[60]); data.bhpbaranim.scale(3.8,1.0,[30],2,[],[60])
    def update(self):
        self.oldndead = self.numdead
        data.bumhp = 0; self.numdead = 0
        for can in self.cans:
            if can.hp <= 0: self.numdead += 1
            data.bumhp += can.hp
        if self.stun > 0: self.stun = max(0.0,self.stun-1.0)
        elif not self.sprite.active():
            if data.bumhp >= 100 and self.oldhp < 100: self.state %= 2
            if 50 <= data.bumhp < 100 and not (50 <= self.oldhp < 100): self.state %= 2
            if data.bumhp < 50 and self.oldhp >= 50: self.state %= 2
            self.oldhp = data.bumhp #last update of state used this value for bumhp (could differ from last frame if stunned)
            if data.bumhp >= 100:
                if self.state % 2: #at random moving stage
                    pygame.mixer.Sound("sound/bumjump.wav").play()
                    self.sprite.pframe.setanimrange(4,4,8,active=True)
                    self.sprite.moveto(100*random.randrange(0,8)+50,self.sprite.cy(),[gamediff.bjumpspeed],0)
                    self.sprite.move(0,-100,[gamediff.bjumpspeed/2],2,[True])
                else: #throw trash slow
                    self.sprite.pframe.setanimrange(16,0,20,0,active=True)
                    self.stun = 30.0
                    sprs.next.append(SOTrash(self.sprite.rect.center,gamediff.bthrowslow))
            elif data.bumhp >= 50: #second third of hp
                if 6 <= self.state <= 7: #threw three, now rez one
                    if self.state == 6: #move to random dead can
                        pygame.mixer.Sound("sound/bumjump.wav").play()
                        self.sprite.pframe.setanimrange(8,8,12,active=True)
                        self.sprite.moveto(100*self.randomdeadcan()+50,self.sprite.cy(),[gamediff.bjumpspeed],0)
                        self.sprite.move(0,-100,[gamediff.bjumpspeed/2],2,[True])
                    else: #rez it
                        pygame.mixer.Sound("sound/raisetrashcan.wav").play()
                        self.stun = 30.0
                        curix = self.sprite.cx()//100
                        self.cans[curix].hp = 20
                        self.cans[curix].sprite.pframe.setanimrange(0,0,0,0)
                elif self.state % 2: #at random moving stage
                    pygame.mixer.Sound("sound/bumjump.wav").play()
                    self.sprite.pframe.setanimrange(4,4,8,active=True)
                    self.sprite.moveto(100*random.randrange(0,8)+50,self.sprite.cy(),[gamediff.bjumpspeed],0)
                    self.sprite.move(0,-100,[gamediff.bjumpspeed/2],2,[True])
                else: #throw trash fast
                    self.sprite.pframe.setanimrange(16,0,20,0,active=True)
                    self.stun = 30.0
                    sprs.next.append(SOTrash(self.sprite.rect.center,gamediff.bthrowfast))
            else: #final third of hp
                if 2 <= self.state <= 3: #threw one, now rez one
                    if self.state == 2: #move to random dead can
                        pygame.mixer.Sound("sound/bumjump.wav").play()
                        self.sprite.pframe.setanimrange(8,8,12,active=True)
                        self.sprite.moveto(100*self.randomdeadcan()+50,self.sprite.cy(),[gamediff.bjumpspeed],0)
                        self.sprite.move(0,-100,[gamediff.bjumpspeed/2],2,[True])
                    else: #rez it
                        pygame.mixer.Sound("sound/raisetrashcan.wav").play()
                        self.stun = 30.0
                        curix = self.sprite.cx()//100
                        self.cans[curix].hp = 20
                        self.cans[curix].sprite.pframe.setanimrange(0,0,0,0)
                elif self.state % 2: #at random moving stage
                    pygame.mixer.Sound("sound/bumjump.wav").play()
                    self.sprite.pframe.setanimrange(4,4,8,active=True)
                    self.sprite.moveto(100*random.randrange(0,7)+50,self.sprite.cy(),[gamediff.bjumpspeed],0)
                    self.sprite.move(0,-100,[gamediff.bjumpspeed/2],2,[True])
                else: #throw dog
                    self.sprite.pframe.setanimrange(16,0,20,0,active=True)
                    self.stun = 30.0
                    sprs.next.append(SODog(self.sprite.rect.center,True))
                    sprs.next[-1].sprite.moveto(player.sprite.cx(),player.sprite.cy()-150,[gamediff.bthrowslow/5.0],0)
                    sprs.next[-1].sprite.move(0,-50,[gamediff.bthrowslow/10.0],2,[True])
            self.state += 1
        self.sprite.update()
        self.colrect.center = (self.sprite.cx() + self.crdata[0],self.sprite.cy() + self.crdata[1])
    def randomdeadcan(self):
        if self.numdead: maxix = random.randrange(0,self.numdead) + 1; i = -1
        else: return random.randrange(0,8) #no cans were killed yet, so just refill one's health
        while maxix > 0 and i < 8:
            i += 1
            if self.cans[i].hp <= 0: maxix -= 1
        return i
    def resolvea(self,sprite,group):
        if isinstance(sprite,SOUmbrellaSW):
            if not (12 <= self.sprite.pframe.ix < 16): self.sprite.pframe.setanimrange(12,12,16,active=True)
            self.stun = 60.0
        elif isinstance(sprite,SOBullet):
            if not (12 <= self.sprite.pframe.ix < 16): self.sprite.pframe.setanimrange(12,12,16,active=True)
            self.stun = 30.0
        return False
    def killcond(self): return False #he never dies, the game ends first
"""-------------------------------------------------------------------------end sprite objects--------------------------------------------------------------------------"""
pygame.mixer.music.load("bgm.mp3")
pygame.mixer.music.play(-1)
if __name__ == "__main__":
    while True:
        window = silen.Sprite(0,["title.png",None,0],(400,300))
        startb = silen.Sprite(0,["start.png",(68,178,142),0],(250,450))
        window.alpha.add([20],255,0); startb.alpha.add([45],255,0,[True,True],[45.0])
        instrns = silen.Sprite(0,["instructions.png",(68,178,142),0],(400,300))
        gamediff = diffeasy
        diffcursor = silen.Sprite(0,["diffcursor.png",(68,178,142),0],(523,403))
        rungame = 0; screensloaded = 0; wait = 20.0
        while rungame < 2 or wait:
            if screensloaded < 20: bkg.bkgs.append(pygame.image.load('bkg/bkg%02d.png' % screensloaded).convert()); screensloaded += 1
            game.event.update(); window.update(); startb.update(); instrns.update(); diffcursor.update()
            wait = max(0.0,wait-1.0)
            if wait == 0.0:
                if rungame == 0:
                    if game.event.hit(pygame.K_RETURN) or game.event.hit(pygame.K_SPACE) or game.event.hit(pygame.K_z) or game.event.hit(pygame.K_x) or game.event.hit(pygame.K_c):
                        instrns.alpha.add([20],255,0); diffcursor.alpha.add([5],255,0,[],[20.0])
                        rungame = 1; wait = 20.0
                elif rungame == 1:
                    if game.event.hit(pygame.K_LEFT) or game.event.hit(pygame.K_RIGHT):
                        if gamediff == diffeasy: gamediff = diffhard; diffcursor.move(51,0,[5],3)
                        else: gamediff = diffeasy; diffcursor.move(-51,0,[5],3)
                    if game.event.hit(pygame.K_RETURN) or game.event.hit(pygame.K_SPACE) or game.event.hit(pygame.K_z) or game.event.hit(pygame.K_x) or game.event.hit(pygame.K_c):
                        startb.alpha.end(); startb.alpha.offset = 0; diffcursor.alpha.end(); diffcursor.alpha.offset = 0
                        window.alpha.add([15],-255,0); instrns.alpha.add([15],-255,0)
                        rungame = 2; game.event.reset(); wait = 15.0
            game.screen.fill((0,0,0))
            game.screen.blit(window(),window.rect)
            game.screen.blit(startb(),startb.rect)
            game.screen.blit(instrns(),instrns.rect)
            game.screen.blit(diffcursor(),diffcursor.rect)
            pygame.display.flip()
            game.clock.tick(31) #fps is always one less, for some reason...
        ytop = 0
        while not data.gameover:
            game.event.update()
            bkg.update()
            if game.event.hit(pygame.K_MINUS): data.hp -= 10
            elif game.event.hit(pygame.K_EQUALS): data.hp += 10
            elif game.event.hit(pygame.K_BACKSPACE): ytop = bkg.skipfive(); lldr.skip(ytop)
            lldr.update(ytop)
            sprs.update()
            sprs.draw(bkg.baked)
            data.draw(bkg.baked)
            pygame.display.set_caption(game.title + (" - FPS: %d" % game.clock.get_fps()))
            game.screen.blit(bkg.baked,Rect(0,0,800,600))
            pygame.display.flip()
            game.clock.tick(31) #fps is always one less, for some reason...
            ytop = max(19*-600,ytop-2)
        if data.won: window = silen.Sprite(0,["win.png",None,0],(400,300))
        else: window = silen.Sprite(0,["lose.png",None,0],(400,300))
        window.alpha.add([20],255,0)
        if data.won: pygame.mixer.Sound("sound/bumcry.wav").play()
        while rungame < 3 or wait:
            game.event.update()
            window.update()
            wait = max(0.0,wait-1.0)
            if wait == 0.0:
                if game.event.hit(pygame.K_z) or game.event.hit(pygame.K_x) or game.event.hit(pygame.K_c):
                    data = DataOrganizer()
                    bkg = BkgLayer(20)
                    sprs.killall()
                    sprs = SpriteManager()
                    lldr = LevelLoader("level.txt")
                    player = PlayerManager(); sprs.insert(player)
                    window.alpha.add([15],-255,0)
                    rungame = 3; game.event.reset(); wait = 15.0
            game.screen.fill((0,0,0))
            game.screen.blit(window(),window.rect)
            pygame.display.flip()
            game.clock.tick(31) #fps is always one less, for some reason...
